/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.register;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.admin.model.entity.MetaDataDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.service.MetaDataService;
import org.apache.shenyu.admin.service.converter.GrpcSelectorHandleConverter;
import org.apache.shenyu.admin.service.register.AbstractShenyuClientRegisterServiceImpl;
import org.apache.shenyu.admin.utils.CommonUpstreamUtils;
import org.apache.shenyu.common.dto.convert.selector.GrpcUpstream;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.enums.EventType;
import org.springframework.stereotype.Service;

@Service
public class ShenyuClientRegisterGrpcServiceImpl
extends AbstractShenyuClientRegisterServiceImpl {
    @Resource
    private GrpcSelectorHandleConverter grpcSelectorHandleConverter;

    @Override
    public String rpcType() {
        return RpcTypeEnum.GRPC.getName();
    }

    @Override
    protected String selectorHandler(MetaDataRegisterDTO metaDataDTO) {
        return "";
    }

    @Override
    protected String ruleHandler() {
        return "";
    }

    @Override
    protected void registerMetadata(MetaDataRegisterDTO metaDataDTO) {
        MetaDataService metaDataService = this.getMetaDataService();
        MetaDataDO exist = metaDataService.findByPath(metaDataDTO.getPath());
        metaDataService.saveOrUpdateMetaData(exist, metaDataDTO);
    }

    @Override
    protected String buildHandle(List<URIRegisterDTO> uriList, SelectorDO selectorDO) {
        List<Object> handleList;
        List existList;
        boolean isEventDeleted;
        List<GrpcUpstream> addList = this.buildGrpcUpstreamList(uriList);
        List<Object> canAddList = new CopyOnWriteArrayList();
        boolean bl = isEventDeleted = uriList.size() == 1 && EventType.DELETED.equals((Object)uriList.get(0).getEventType());
        if (isEventDeleted) {
            addList.get(0).setStatus(false);
        }
        if (CollectionUtils.isEmpty((Collection)(existList = GsonUtils.getInstance().fromCurrentList(selectorDO.getHandle(), GrpcUpstream.class)))) {
            canAddList = addList;
        } else {
            List diffStatusList;
            List diffList = addList.stream().filter(upstream -> !existList.contains(upstream)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(diffList)) {
                canAddList.addAll(diffList);
                existList.addAll(diffList);
            }
            if (CollectionUtils.isNotEmpty(diffStatusList = addList.stream().filter(upstream -> !upstream.isStatus() || existList.stream().anyMatch(e -> e.equals(upstream) && e.isStatus() != upstream.isStatus())).collect(Collectors.toList()))) {
                canAddList.addAll(diffStatusList);
            }
        }
        if (this.doSubmit(selectorDO.getId(), canAddList)) {
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)existList)) {
            handleList = addList;
        } else {
            List<Object> aliveList = isEventDeleted ? existList.stream().filter(e -> e.isStatus() && !e.equals(addList.get(0))).collect(Collectors.toList()) : addList;
            handleList = this.grpcSelectorHandleConverter.updateStatusAndFilter(existList, aliveList);
        }
        return GsonUtils.getInstance().toJson(handleList);
    }

    private List<GrpcUpstream> buildGrpcUpstreamList(List<URIRegisterDTO> uriList) {
        return uriList.stream().map(dto -> CommonUpstreamUtils.buildDefaultGrpcUpstream(dto.getHost(), dto.getPort())).collect(Collectors.toCollection(CopyOnWriteArrayList::new));
    }
}

