/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.spring;

import com.google.common.base.Splitter;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.shenyu.admin.config.properties.DataBaseProperties;
import org.apache.shenyu.admin.utils.SQLInitUtils;
import org.apache.shenyu.common.exception.ShenyuException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnExpression(value="'${shenyu.database.dialect}' == 'mysql' or '${shenyu.database.dialect}' == 'h2'")
public class LocalDataSourceLoader
implements InstantiationAwareBeanPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(LocalDataSourceLoader.class);
    private static final String PRE_FIX = "file:";
    private static final String SQL_COMMAND = "INSERT IGNORE INTO";
    private static final String DELIMITER = ";";
    @Resource
    private DataBaseProperties dataBaseProperties;

    public Object postProcessAfterInitialization(@NonNull Object bean, String beanName) throws BeansException {
        if (bean instanceof DataSourceProperties && this.dataBaseProperties.getInitEnable().booleanValue()) {
            this.init((DataSourceProperties)bean);
        }
        return bean;
    }

    protected void init(DataSourceProperties properties) {
        try {
            String jdbcUrl = StringUtils.replace((String)properties.getUrl(), (String)"/shenyu?", (String)"?");
            Connection connection = DriverManager.getConnection(jdbcUrl, properties.getUsername(), properties.getPassword());
            this.execute(connection, this.dataBaseProperties.getInitScript());
        }
        catch (Exception e) {
            LOG.error("Datasource init error.", (Throwable)e);
            throw new ShenyuException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(Connection conn, String script) throws Exception {
        ScriptRunner runner = new ScriptRunner(conn);
        try {
            runner.setLogWriter(null);
            runner.setAutoCommit(true);
            runner.setFullLineDelimiter(false);
            runner.setDelimiter(DELIMITER);
            runner.setSendFullScript(false);
            runner.setStopOnError(false);
            Resources.setCharset((Charset)StandardCharsets.UTF_8);
            List initScripts = Splitter.on((String)DELIMITER).splitToList((CharSequence)script);
            for (String sqlScript : initScripts) {
                Reader fileReader = this.fillIdInfoToSqlFile(sqlScript, (String[])Stream.of("shenyu_dict", "plugin_handle").toArray(String[]::new), "id");
                Throwable throwable = null;
                try {
                    LOG.info("execute shenyu schema sql: {}", (Object)sqlScript);
                    runner.runScript(fileReader);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fileReader == null) continue;
                    if (throwable != null) {
                        try {
                            fileReader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fileReader.close();
                }
            }
        }
        finally {
            runner.closeConnection();
        }
    }

    private Reader fillIdInfoToSqlFile(String sqlScript, String[] regxNames, String regxValue) throws IOException {
        String str;
        BufferedReader reader;
        StringBuilder builder = new StringBuilder();
        if (sqlScript.startsWith(PRE_FIX)) {
            String sqlFile = sqlScript.substring(PRE_FIX.length());
            reader = new BufferedReader(this.getResourceAsReader(sqlFile));
        } else {
            reader = new BufferedReader(Resources.getResourceAsReader((String)sqlScript));
        }
        while (Objects.nonNull(str = reader.readLine())) {
            if (!(str = str.trim().replaceAll("\\s+", " ")).toUpperCase().contains(SQL_COMMAND)) {
                builder.append(str).append(System.lineSeparator());
                continue;
            }
            for (String regxName : regxNames) {
                if (!str.contains(regxName)) continue;
                str = SQLInitUtils.concatCharacter(str, regxValue, "mysql");
                break;
            }
            builder.append(str).append(System.lineSeparator());
        }
        reader.close();
        return new StringReader(builder.toString());
    }

    private Reader getResourceAsReader(String resource) throws IOException {
        return new InputStreamReader((InputStream)new FileInputStream(resource), StandardCharsets.UTF_8);
    }
}

