/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.ProxyGatewayDTO;
import org.apache.shenyu.admin.model.entity.AppAuthDO;
import org.apache.shenyu.admin.service.AppAuthService;
import org.apache.shenyu.admin.utils.Assert;
import org.apache.shenyu.admin.utils.HttpUtils;
import org.apache.shenyu.admin.utils.ShenyuSignatureUtils;
import org.apache.shenyu.admin.utils.UploadUtils;
import org.apache.shenyu.common.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

@RestController
@RequestMapping(value={"/sandbox"})
public class SandboxController {
    private static final Logger LOG = LoggerFactory.getLogger(SandboxController.class);
    private static final HttpUtils HTTP_UTILS = new HttpUtils();
    private final AppAuthService appAuthService;

    public SandboxController(AppAuthService appAuthService) {
        this.appAuthService = appAuthService;
    }

    @PostMapping(path={"/proxyGateway"})
    public void proxyGateway(@RequestBody @Valid ProxyGatewayDTO proxyGatewayDTO, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map<String, String> header = this.buildReqHeaders(proxyGatewayDTO);
        String appKey = proxyGatewayDTO.getAppKey();
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)proxyGatewayDTO.getRequestUrl()).build();
        String signContent = null;
        String sign = null;
        if (StringUtils.isNotEmpty((CharSequence)appKey)) {
            String timestamp = String.valueOf(LocalDateTime.now().toInstant(ZoneOffset.of("+8")).toEpochMilli());
            String secureKey = this.getSecureKey(appKey);
            Assert.notBlack(secureKey, "sign appKey does not exist.");
            signContent = ShenyuSignatureUtils.getSignContent(secureKey, timestamp, uriComponents.getPath());
            sign = ShenyuSignatureUtils.generateSign(signContent);
            header.put("timestamp", timestamp);
            header.put("appKey", appKey);
            header.put("sign", sign);
            header.put("version", "1.0.0");
        }
        Map<String, Object> reqParams = this.buildReqBizParams(proxyGatewayDTO);
        List<HttpUtils.UploadFile> files = this.uploadFiles(request);
        Response resp = HTTP_UTILS.requestCall(uriComponents.toUriString(), reqParams, header, HttpUtils.HTTPMethod.fromValue(proxyGatewayDTO.getHttpMethod()), files);
        ResponseBody body = resp.body();
        if (Objects.isNull(body)) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)appKey)) {
            response.addHeader("sandbox-beforesign", UriUtils.encode((String)signContent, (Charset)StandardCharsets.UTF_8));
            response.addHeader("sandbox-sign", UriUtils.encode((String)sign, (Charset)StandardCharsets.UTF_8));
        }
        IOUtils.copy((InputStream)body.byteStream(), (OutputStream)response.getOutputStream());
        response.flushBuffer();
    }

    private Map<String, String> buildReqHeaders(ProxyGatewayDTO proxyGatewayDTO) {
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        reqHeaders.put("Cookie", proxyGatewayDTO.getCookie());
        try {
            String reqJson = JsonUtils.toJson((Object)proxyGatewayDTO.getHeaders());
            reqJson = StringEscapeUtils.escapeHtml4((String)reqJson);
            Map reqMap = JsonUtils.jsonToMap((String)reqJson, String.class);
            LOG.info("bizParam toMap= {}", (Object)JsonUtils.toJson((Object)reqMap));
            reqHeaders.putAll(reqMap);
        }
        catch (Exception e) {
            LOG.error("proxyGateway JsonUtils.toMap error={}", (Throwable)e);
        }
        return reqHeaders;
    }

    private Map<String, Object> buildReqBizParams(ProxyGatewayDTO proxyGatewayDTO) {
        HashMap<String, Object> reqParams = new HashMap<String, Object>();
        try {
            String reqJson = JsonUtils.toJson((Object)proxyGatewayDTO.getBizParam());
            reqJson = StringEscapeUtils.escapeHtml4((String)reqJson);
            Map reqMap = JsonUtils.toMap((Object)reqJson);
            LOG.info("bizParam toMap= {}", (Object)JsonUtils.toJson((Object)reqMap));
            reqParams.putAll(reqMap);
        }
        catch (Exception e) {
            LOG.error("proxyGateway JsonUtils.toMap error={}", (Throwable)e);
        }
        return reqParams;
    }

    private String getSecureKey(String appKey) {
        AppAuthDO appAuthDO = this.appAuthService.findByAppKey(appKey);
        return Objects.nonNull(appAuthDO) ? appAuthDO.getAppSecret() : null;
    }

    private List<HttpUtils.UploadFile> uploadFiles(HttpServletRequest request) {
        Collection<MultipartFile> uploadFiles = UploadUtils.getUploadFiles(request);
        List<HttpUtils.UploadFile> files = uploadFiles.stream().map(multipartFile -> {
            try {
                return new HttpUtils.UploadFile(multipartFile.getName(), multipartFile.getOriginalFilename(), multipartFile.getBytes());
            }
            catch (IOException e) {
                LOG.error("upload file fail", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return files;
    }
}

