/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.event.metadata;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.MetaDataDO;
import org.apache.shenyu.admin.model.enums.EventTypeEnum;
import org.apache.shenyu.admin.model.event.metadata.BatchMetaDataChangedEvent;
import org.apache.shenyu.admin.utils.ListUtil;

public class BatchMetaDataDeletedEvent
extends BatchMetaDataChangedEvent {
    private final List<String> deletedIds;

    public BatchMetaDataDeletedEvent(Collection<MetaDataDO> source, String operator) {
        super(source, (Collection<MetaDataDO>)null, EventTypeEnum.META_DATA_DELETE, operator);
        this.deletedIds = ListUtil.map(source, BaseDO::getId);
    }

    @Override
    public String buildContext() {
        String metaData = ((Collection)this.getSource()).stream().map(s -> ((MetaDataDO)s).getAppName()).collect(Collectors.joining(","));
        return String.format("the meta data[%s] is %s", metaData, StringUtils.lowerCase((String)this.getType().getType().toString()));
    }

    public List<String> getDeletedIds() {
        return this.deletedIds;
    }
}

