/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageCondition;
import org.apache.shenyu.admin.model.page.PageParameter;

public interface PageService<Q, R> {
    default public PageInfo<R> searchByPage(PageCondition<Q> pageCondition) {
        this.doConditionPreProcessing(pageCondition.getCondition());
        PageHelper.startPage((int)pageCondition.getPageNum(), (int)pageCondition.getPageSize());
        return new PageInfo(this.searchByCondition(pageCondition.getCondition()));
    }

    default public CommonPager<R> searchByPageToPager(PageCondition<Q> pageCondition) {
        PageInfo<R> pageInfo = this.searchByPage(pageCondition);
        return new CommonPager(new PageParameter(pageCondition.getPageNum(), pageCondition.getPageSize(), (int)pageInfo.getTotal()), pageInfo.getList());
    }

    default public List<R> searchByCondition(Q condition) {
        return new ArrayList();
    }

    default public void doConditionPreProcessing(Q condition) {
    }
}

