/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.admin.aspect.annotation.Pageable;
import org.apache.shenyu.admin.mapper.PluginHandleMapper;
import org.apache.shenyu.admin.mapper.ShenyuDictMapper;
import org.apache.shenyu.admin.model.dto.PluginHandleDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.PluginHandleDO;
import org.apache.shenyu.admin.model.event.plugin.BatchPluginDeletedEvent;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.PluginHandleQuery;
import org.apache.shenyu.admin.model.vo.PluginHandleVO;
import org.apache.shenyu.admin.model.vo.ShenyuDictVO;
import org.apache.shenyu.admin.service.PluginHandleService;
import org.apache.shenyu.admin.service.publish.PluginHandleEventPublisher;
import org.apache.shenyu.admin.utils.ListUtil;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class PluginHandleServiceImpl
implements PluginHandleService {
    private static final int SELECT_BOX_DATA_TYPE = 3;
    private final PluginHandleMapper pluginHandleMapper;
    private final ShenyuDictMapper shenyuDictMapper;
    private final PluginHandleEventPublisher eventPublisher;

    public PluginHandleServiceImpl(PluginHandleMapper pluginHandleMapper, ShenyuDictMapper shenyuDictMapper, PluginHandleEventPublisher eventPublisher) {
        this.pluginHandleMapper = pluginHandleMapper;
        this.shenyuDictMapper = shenyuDictMapper;
        this.eventPublisher = eventPublisher;
    }

    @Override
    @Pageable
    public CommonPager<PluginHandleVO> listByPage(PluginHandleQuery pluginHandleQuery) {
        List<PluginHandleDO> pluginHandleDOList = this.pluginHandleMapper.selectByQuery(pluginHandleQuery);
        return PageResultUtils.result(pluginHandleQuery.getPageParameter(), () -> this.buildPluginHandleVO(pluginHandleDOList));
    }

    @Override
    public Integer create(PluginHandleDTO pluginHandleDTO) {
        PluginHandleDO pluginHandleDO = PluginHandleDO.buildPluginHandleDO(pluginHandleDTO);
        int pluginHandleCount = this.pluginHandleMapper.insertSelective(pluginHandleDO);
        if (pluginHandleCount > 0) {
            this.eventPublisher.onCreated(pluginHandleDO);
        }
        return pluginHandleCount;
    }

    @Override
    public Integer update(PluginHandleDTO pluginHandleDTO) {
        PluginHandleDO pluginHandleDO = PluginHandleDO.buildPluginHandleDO(pluginHandleDTO);
        PluginHandleDO before = this.pluginHandleMapper.selectById(pluginHandleDTO.getId());
        int pluginHandleCount = this.pluginHandleMapper.updateByPrimaryKeySelective(pluginHandleDO);
        if (pluginHandleCount > 0) {
            this.eventPublisher.onUpdated(pluginHandleDO, before);
        }
        return pluginHandleCount;
    }

    @Override
    public Integer deletePluginHandles(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return 0;
        }
        List<PluginHandleDO> handles = this.pluginHandleMapper.selectByIdList(ids);
        int count = this.pluginHandleMapper.deleteByIdList(ids);
        if (count > 0) {
            this.eventPublisher.onDeleted((Collection<PluginHandleDO>)handles);
        }
        return count;
    }

    @Override
    public PluginHandleVO findById(String id) {
        return this.buildPluginHandleVO(this.pluginHandleMapper.selectById(id));
    }

    @Override
    public List<PluginHandleVO> list(String pluginId, Integer type) {
        List<PluginHandleDO> pluginHandleDOList = this.pluginHandleMapper.selectByQuery(PluginHandleQuery.builder().pluginId(pluginId).type(type).build());
        return this.buildPluginHandleVO(pluginHandleDOList);
    }

    @EventListener(value={BatchPluginDeletedEvent.class})
    public void onPluginDeleted(BatchPluginDeletedEvent event) {
        this.deletePluginHandles(ListUtil.map(this.pluginHandleMapper.selectByPluginIdList(event.getDeletedPluginIds()), BaseDO::getId));
    }

    private PluginHandleVO buildPluginHandleVO(PluginHandleDO pluginHandleDO) {
        List<ShenyuDictVO> dictOptions = null;
        if (pluginHandleDO.getDataType() == 3) {
            dictOptions = ListUtil.map(this.shenyuDictMapper.findByType(pluginHandleDO.getField()), ShenyuDictVO::buildShenyuDictVO);
        }
        return PluginHandleVO.buildPluginHandleVO(pluginHandleDO, dictOptions);
    }

    private List<PluginHandleVO> buildPluginHandleVO(List<PluginHandleDO> pluginHandleDOList) {
        List<String> fieldList = pluginHandleDOList.stream().filter(pluginHandleDO -> pluginHandleDO.getDataType() == 3).map(PluginHandleDO::getField).distinct().collect(Collectors.toList());
        HashMap shenyuDictMap = CollectionUtils.isNotEmpty(fieldList) ? Optional.ofNullable(this.shenyuDictMapper.findByTypeBatch(fieldList)).orElseGet(ArrayList::new).stream().map(ShenyuDictVO::buildShenyuDictVO).collect(Collectors.groupingBy(ShenyuDictVO::getType)) : new HashMap(0);
        return pluginHandleDOList.stream().map(pluginHandleDO -> {
            List dictOptions = (List)shenyuDictMap.get(pluginHandleDO.getField());
            return PluginHandleVO.buildPluginHandleVO(pluginHandleDO, dictOptions);
        }).collect(Collectors.toList());
    }
}

