/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.aspect.controller;

import com.google.common.base.Stopwatch;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.apache.shenyu.admin.aspect.controller.ControllerMethodAdvice;
import org.apache.shenyu.admin.config.properties.DashboardProperties;
import org.apache.shenyu.admin.utils.SessionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PrintLogControllerMethodAdviceImpl
implements ControllerMethodAdvice {
    private static final Logger LOG = LoggerFactory.getLogger(PrintLogControllerMethodAdviceImpl.class);
    private final DashboardProperties properties;

    public PrintLogControllerMethodAdviceImpl(DashboardProperties properties) {
        this.properties = properties;
    }

    @Override
    public void doPreProcess(Object bean, Method method, Stopwatch stopwatch) {
        if (Boolean.TRUE.equals(this.properties.getEnablePrintApiLog())) {
            LOG.info("{} exec: method [{}.{}]", new Object[]{SessionUtil.visitorName(), bean.getClass().getSimpleName(), method.getName()});
        }
    }

    @Override
    public void doFinally(Object bean, Method method, Stopwatch stopwatch) {
        if (Boolean.TRUE.equals(this.properties.getEnablePrintApiLog())) {
            LOG.info("{} exec: method [{}.{}] over, time cost: {}", new Object[]{SessionUtil.visitorName(), bean.getClass().getSimpleName(), method.getName(), stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        }
    }
}

