/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.config;

import com.ecwid.consul.v1.ConsulClient;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.register.client.server.consul.ShenyuConsulConfigWatch;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="shenyu.register", name={"registerType"}, havingValue="consul")
public class ConsulServerConfiguration {
    @Bean(name={"registerConsulClient"})
    public ConsulClient consulClient(ShenyuRegisterCenterConfig config) {
        String serverList = config.getServerLists();
        if (StringUtils.isBlank((CharSequence)serverList)) {
            throw new ShenyuException("serverList can not be null.");
        }
        String[] addresses = serverList.split(":");
        if (addresses.length != 2) {
            throw new ShenyuException("serverList formatter is not incorrect.");
        }
        return new ConsulClient(addresses[0], Integer.parseInt(addresses[1]));
    }

    @Bean
    public ShenyuConsulConfigWatch shenyuConsulConfigWatch(ShenyuRegisterCenterConfig config, ApplicationEventPublisher publisher) {
        return new ShenyuConsulConfigWatch(config, publisher);
    }
}

