/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.apache.shenyu.admin.mapper.PluginMapper;
import org.apache.shenyu.admin.model.dto.DiscoveryUpstreamDTO;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.service.DiscoveryUpstreamService;
import org.apache.shenyu.admin.validation.annotation.Existed;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/discovery-upstream"})
@Validated
public class DiscoveryUpstreamController {
    private final DiscoveryUpstreamService discoveryUpstreamService;

    public DiscoveryUpstreamController(DiscoveryUpstreamService discoveryUpstreamService) {
        this.discoveryUpstreamService = discoveryUpstreamService;
    }

    @PostMapping(value={""})
    public ShenyuAdminResult createDiscoveryUpstream(@Valid @RequestBody DiscoveryUpstreamDTO discoveryUpstreamDTO) {
        return ShenyuAdminResult.success(this.discoveryUpstreamService.createOrUpdate(discoveryUpstreamDTO));
    }

    @PutMapping(value={"/{id}"})
    public ShenyuAdminResult updateDiscoveryUpstream(@PathVariable(value="id") @Existed(message="discovery upstream is not existed", provider=PluginMapper.class) @Existed(message="discovery upstream is not existed", provider=PluginMapper.class) String id, @Valid @RequestBody DiscoveryUpstreamDTO discoveryUpstreamDTO) {
        discoveryUpstreamDTO.setId(id);
        return ShenyuAdminResult.success(this.discoveryUpstreamService.createOrUpdate(discoveryUpstreamDTO));
    }

    @DeleteMapping(value={"/batch"})
    public ShenyuAdminResult deleteDiscoveryUpstream(@NotEmpty @RequestBody @NotEmpty List<@NotBlank String> ids) {
        return ShenyuAdminResult.success(this.discoveryUpstreamService.delete(ids));
    }
}

