/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.apache.shenyu.admin.mapper.TagMapper;
import org.apache.shenyu.admin.model.dto.TagDTO;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.TagVO;
import org.apache.shenyu.admin.service.TagService;
import org.apache.shenyu.admin.validation.annotation.Existed;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/tag"})
public class TagController {
    private final TagService tagService;

    public TagController(TagService tagService) {
        this.tagService = tagService;
    }

    @PostMapping(value={""})
    public ShenyuAdminResult createTag(@Valid @RequestBody TagDTO tagDTO) {
        Integer createCount = this.tagService.create(tagDTO);
        return ShenyuAdminResult.success("create success", createCount);
    }

    @GetMapping(value={"/queryRootTag"})
    public ShenyuAdminResult queryRootTag() {
        return ShenyuAdminResult.success("query success", this.tagService.findByParentTagId("0"));
    }

    @GetMapping(value={"/id/{id}"})
    public ShenyuAdminResult queryById(@PathVariable(value="id") @Valid @Existed(provider=TagMapper.class, message="tag is not existed") @Valid @Existed(provider=TagMapper.class, message="tag is not existed") String id) {
        TagVO tagVO = this.tagService.findById(id);
        return ShenyuAdminResult.success("detail success", tagVO);
    }

    @GetMapping(value={"/parentTagId/{parentTagId}"})
    public ShenyuAdminResult queryListByParentTagId(@PathVariable(value="parentTagId") @Valid String parentTagId) {
        List<TagVO> tagVOList = Optional.ofNullable(this.tagService.findByParentTagId(parentTagId)).orElse(Lists.newArrayList());
        return ShenyuAdminResult.success("detail success", tagVOList);
    }

    @GetMapping(value={"/name/{name}"})
    public ShenyuAdminResult queryByName(@PathVariable(value="name") @Valid String name) {
        List<TagVO> tagVO = this.tagService.findByQuery(name);
        return ShenyuAdminResult.success("detail success", tagVO);
    }

    @PutMapping(value={"/id/{id}"})
    public ShenyuAdminResult updateTag(@PathVariable(value="id") @Valid String id, @Valid @RequestBody TagDTO tagDTO) {
        tagDTO.setId(id);
        Integer updateCount = this.tagService.update(tagDTO);
        return ShenyuAdminResult.success("update success", updateCount);
    }

    @DeleteMapping(value={"/batchDelete"})
    public ShenyuAdminResult deleteTags(@RequestBody @NotEmpty List<@NotBlank String> ids) {
        Integer deleteCount = this.tagService.delete(ids);
        return ShenyuAdminResult.success("delete success", deleteCount);
    }
}

