/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.discovery;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.discovery.DiscoveryDataChangedEventSyncListener;
import org.apache.shenyu.admin.discovery.DiscoveryProcessor;
import org.apache.shenyu.admin.discovery.parse.CustomDiscoveryUpstreamParser;
import org.apache.shenyu.admin.exception.ShenyuAdminException;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.DiscoveryHandlerMapper;
import org.apache.shenyu.admin.mapper.DiscoveryUpstreamMapper;
import org.apache.shenyu.admin.mapper.ProxySelectorMapper;
import org.apache.shenyu.admin.model.dto.DiscoveryHandlerDTO;
import org.apache.shenyu.admin.model.dto.DiscoveryUpstreamDTO;
import org.apache.shenyu.admin.model.dto.ProxySelectorDTO;
import org.apache.shenyu.admin.model.entity.DiscoveryDO;
import org.apache.shenyu.admin.model.entity.DiscoveryHandlerDO;
import org.apache.shenyu.admin.model.entity.DiscoveryUpstreamDO;
import org.apache.shenyu.admin.model.entity.ProxySelectorDO;
import org.apache.shenyu.admin.transfer.DiscoveryTransfer;
import org.apache.shenyu.common.dto.DiscoverySyncData;
import org.apache.shenyu.common.dto.DiscoveryUpstreamData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.apache.shenyu.discovery.api.ShenyuDiscoveryService;
import org.apache.shenyu.discovery.api.config.DiscoveryConfig;
import org.apache.shenyu.discovery.api.listener.DataChangedEventListener;
import org.apache.shenyu.spi.ExtensionLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public class DefaultDiscoveryProcessor
implements DiscoveryProcessor,
ApplicationEventPublisherAware {
    private static final String DEFAULT_LISTENER_NODE = "/shenyu/discovery";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDiscoveryProcessor.class);
    private final Map<String, ShenyuDiscoveryService> discoveryServiceCache;
    private final Map<String, Set<String>> dataChangedEventListenerCache;
    private ApplicationEventPublisher eventPublisher;
    private final DiscoveryUpstreamMapper discoveryUpstreamMapper;
    private final DiscoveryHandlerMapper discoveryHandlerMapper;
    private final ProxySelectorMapper proxySelectorMapper;

    public DefaultDiscoveryProcessor(DiscoveryUpstreamMapper discoveryUpstreamMapper, DiscoveryHandlerMapper discoveryHandlerMapper, ProxySelectorMapper proxySelectorMapper) {
        this.discoveryUpstreamMapper = discoveryUpstreamMapper;
        this.discoveryServiceCache = new ConcurrentHashMap<String, ShenyuDiscoveryService>();
        this.discoveryHandlerMapper = discoveryHandlerMapper;
        this.dataChangedEventListenerCache = new ConcurrentHashMap<String, Set<String>>();
        this.proxySelectorMapper = proxySelectorMapper;
    }

    @Override
    public void createDiscovery(DiscoveryDO discoveryDO) {
        if (this.discoveryServiceCache.containsKey(discoveryDO.getId())) {
            LOG.info("shenyu DiscoveryProcessor {} discovery has been init", (Object)discoveryDO.getId());
            return;
        }
        String type = discoveryDO.getType();
        String props = discoveryDO.getProps();
        Properties properties = (Properties)GsonUtils.getGson().fromJson(props, Properties.class);
        DiscoveryConfig discoveryConfig = new DiscoveryConfig();
        discoveryConfig.setType(type);
        discoveryConfig.setProps(properties);
        discoveryConfig.setServerList(discoveryDO.getServerList());
        ShenyuDiscoveryService discoveryService = (ShenyuDiscoveryService)ExtensionLoader.getExtensionLoader(ShenyuDiscoveryService.class).getJoin(type);
        discoveryService.init(discoveryConfig);
        this.discoveryServiceCache.put(discoveryDO.getId(), discoveryService);
        this.dataChangedEventListenerCache.put(discoveryDO.getId(), new HashSet());
    }

    @Override
    public void createProxySelector(DiscoveryHandlerDTO discoveryHandlerDTO, ProxySelectorDTO proxySelectorDTO) {
        ShenyuDiscoveryService shenyuDiscoveryService = this.discoveryServiceCache.get(discoveryHandlerDTO.getDiscoveryId());
        String key = this.buildProxySelectorKey(discoveryHandlerDTO.getListenerNode());
        if (Objects.isNull(shenyuDiscoveryService)) {
            throw new ShenyuAdminException(String.format("before start ProxySelector you need init DiscoveryId=%s", discoveryHandlerDTO.getDiscoveryId()));
        }
        if (!shenyuDiscoveryService.exits(key).booleanValue()) {
            throw new ShenyuAdminException(String.format("shenyu discovery start watcher need you has this key %s in Discovery", key));
        }
        Set<String> cacheKey = this.dataChangedEventListenerCache.get(discoveryHandlerDTO.getDiscoveryId());
        if (Objects.nonNull(cacheKey) && cacheKey.contains(key)) {
            throw new ShenyuAdminException(String.format("shenyu discovery has watcher key = %s", key));
        }
        shenyuDiscoveryService.watcher(key, this.getDiscoveryDataChangedEventListener(discoveryHandlerDTO, proxySelectorDTO));
        cacheKey.add(key);
        DataChangedEvent dataChangedEvent = new DataChangedEvent(ConfigGroupEnum.PROXY_SELECTOR, DataEventTypeEnum.CREATE, Collections.singletonList(DiscoveryTransfer.INSTANCE.mapToData(proxySelectorDTO)));
        this.eventPublisher.publishEvent((ApplicationEvent)dataChangedEvent);
    }

    @Override
    public void removeDiscovery(DiscoveryDO discoveryDO) {
        ShenyuDiscoveryService shenyuDiscoveryService = this.discoveryServiceCache.get(discoveryDO.getId());
        shenyuDiscoveryService.shutdown();
        LOG.info("shenyu discovery shutdown [{}] discovery", (Object)discoveryDO.getName());
    }

    @Override
    public void removeProxySelector(DiscoveryHandlerDTO discoveryHandlerDTO, ProxySelectorDTO proxySelectorDTO) {
        ShenyuDiscoveryService shenyuDiscoveryService = this.discoveryServiceCache.get(discoveryHandlerDTO.getDiscoveryId());
        String key = this.buildProxySelectorKey(discoveryHandlerDTO.getListenerNode());
        Set<String> cacheKey = this.dataChangedEventListenerCache.get(discoveryHandlerDTO.getDiscoveryId());
        cacheKey.remove(key);
        shenyuDiscoveryService.unWatcher(key);
        DataChangedEvent dataChangedEvent = new DataChangedEvent(ConfigGroupEnum.PROXY_SELECTOR, DataEventTypeEnum.DELETE, Collections.singletonList(DiscoveryTransfer.INSTANCE.mapToData(proxySelectorDTO)));
        this.eventPublisher.publishEvent((ApplicationEvent)dataChangedEvent);
    }

    @Override
    public void changeUpstream(ProxySelectorDTO proxySelectorDTO, List<DiscoveryUpstreamDTO> upstreamDTOS) {
        throw new NotImplementedException("shenyu discovery local mode do nothing in changeUpstream");
    }

    @Override
    public void fetchAll(String discoveryHandlerId) {
        DiscoveryHandlerDO discoveryHandlerDO = this.discoveryHandlerMapper.selectById(discoveryHandlerId);
        String discoveryId = discoveryHandlerDO.getDiscoveryId();
        if (this.discoveryServiceCache.containsKey(discoveryId)) {
            ShenyuDiscoveryService shenyuDiscoveryService = this.discoveryServiceCache.get(discoveryId);
            List childData = shenyuDiscoveryService.getRegisterData(this.buildProxySelectorKey(discoveryHandlerDO.getListenerNode()));
            List discoveryUpstreamDataList = childData.stream().map(s -> (DiscoveryUpstreamData)GsonUtils.getGson().fromJson(s, DiscoveryUpstreamData.class)).collect(Collectors.toList());
            Set urlList = discoveryUpstreamDataList.stream().map(DiscoveryUpstreamData::getUrl).collect(Collectors.toSet());
            List<DiscoveryUpstreamDO> discoveryUpstreamDOS = this.discoveryUpstreamMapper.selectByDiscoveryHandlerId(discoveryHandlerId);
            Set dbUrlList = discoveryUpstreamDOS.stream().map(DiscoveryUpstreamDO::getUrl).collect(Collectors.toSet());
            ArrayList<String> deleteIds = new ArrayList<String>();
            for (DiscoveryUpstreamDO discoveryUpstreamDO : discoveryUpstreamDOS) {
                if (urlList.contains(discoveryUpstreamDO.getUrl())) continue;
                deleteIds.add(discoveryUpstreamDO.getId());
            }
            if (!deleteIds.isEmpty()) {
                this.discoveryUpstreamMapper.deleteByIds(deleteIds);
            }
            for (DiscoveryUpstreamData currDiscoveryUpstreamDate : discoveryUpstreamDataList) {
                if (dbUrlList.contains(currDiscoveryUpstreamDate.getUrl())) continue;
                DiscoveryUpstreamDO discoveryUpstreamDO = DiscoveryTransfer.INSTANCE.mapToDo(currDiscoveryUpstreamDate);
                discoveryUpstreamDO.setId(UUIDUtils.getInstance().generateShortUuid());
                discoveryUpstreamDO.setDiscoveryHandlerId(discoveryHandlerId);
                discoveryUpstreamDO.setDateCreated(new Timestamp(System.currentTimeMillis()));
                discoveryUpstreamDO.setDateUpdated(new Timestamp(System.currentTimeMillis()));
                this.discoveryUpstreamMapper.insert(discoveryUpstreamDO);
            }
            ProxySelectorDO proxySelectorDO = this.proxySelectorMapper.selectByHandlerId(discoveryHandlerId);
            DiscoverySyncData discoverySyncData = new DiscoverySyncData();
            discoverySyncData.setSelectorId(proxySelectorDO.getId());
            discoverySyncData.setSelectorName(proxySelectorDO.getName());
            discoverySyncData.setPluginName(proxySelectorDO.getPluginName());
            discoverySyncData.setUpstreamDataList(discoveryUpstreamDataList);
            DataChangedEvent dataChangedEvent = new DataChangedEvent(ConfigGroupEnum.DISCOVER_UPSTREAM, DataEventTypeEnum.UPDATE, Collections.singletonList(discoverySyncData));
            this.eventPublisher.publishEvent((ApplicationEvent)dataChangedEvent);
        }
    }

    private String buildProxySelectorKey(String listenerNode) {
        return StringUtils.isNotBlank((CharSequence)listenerNode) ? listenerNode : DEFAULT_LISTENER_NODE;
    }

    private DataChangedEventListener getDiscoveryDataChangedEventListener(DiscoveryHandlerDTO discoveryHandlerDTO, ProxySelectorDTO proxySelectorDTO) {
        Map customMap = GsonUtils.getInstance().toObjectMap(discoveryHandlerDTO.getHandler(), String.class);
        DiscoverySyncData discoverySyncData = new DiscoverySyncData();
        discoverySyncData.setPluginName(proxySelectorDTO.getPluginName());
        discoverySyncData.setSelectorName(proxySelectorDTO.getName());
        discoverySyncData.setSelectorId(proxySelectorDTO.getId());
        return new DiscoveryDataChangedEventSyncListener(this.eventPublisher, this.discoveryUpstreamMapper, new CustomDiscoveryUpstreamParser(customMap), discoveryHandlerDTO.getId(), discoverySyncData);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }
}

