/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.discovery;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.admin.discovery.parse.KeyValueParser;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.DiscoveryUpstreamMapper;
import org.apache.shenyu.admin.model.entity.DiscoveryUpstreamDO;
import org.apache.shenyu.admin.transfer.DiscoveryTransfer;
import org.apache.shenyu.common.dto.DiscoverySyncData;
import org.apache.shenyu.common.dto.DiscoveryUpstreamData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.apache.shenyu.discovery.api.listener.DataChangedEventListener;
import org.apache.shenyu.discovery.api.listener.DiscoveryDataChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class DiscoveryDataChangedEventSyncListener
implements DataChangedEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiscoveryDataChangedEventSyncListener.class);
    private final KeyValueParser keyValueParser;
    private final ApplicationEventPublisher eventPublisher;
    private final DiscoveryUpstreamMapper discoveryUpstreamMapper;
    private final String discoveryHandlerId;
    private final DiscoverySyncData contextInfo;

    public DiscoveryDataChangedEventSyncListener(ApplicationEventPublisher eventPublisher, DiscoveryUpstreamMapper discoveryUpstreamMapper, KeyValueParser keyValueParser, String discoveryHandlerId, DiscoverySyncData contextInfo) {
        this.eventPublisher = eventPublisher;
        this.keyValueParser = keyValueParser;
        this.discoveryUpstreamMapper = discoveryUpstreamMapper;
        this.discoveryHandlerId = discoveryHandlerId;
        this.contextInfo = contextInfo;
    }

    public void onChange(DiscoveryDataChangedEvent event) {
        DiscoveryDataChangedEvent.Event currentEvent = event.getEvent();
        if (DiscoveryDataChangedEvent.Event.IGNORED.equals((Object)currentEvent)) {
            return;
        }
        DiscoverySyncData discoverySyncData = this.buildProxySelectorData(event.getValue());
        List upstreamDataList = discoverySyncData.getUpstreamDataList();
        if (CollectionUtils.isEmpty((Collection)upstreamDataList)) {
            LOGGER.warn("shenyu proxySelectorData#discoveryUpstreamList is empty");
            return;
        }
        switch (currentEvent) {
            case ADDED: {
                upstreamDataList.forEach(d -> {
                    if (Objects.isNull(this.discoveryUpstreamMapper.selectByDiscoveryHandlerIdAndUrl(this.discoveryHandlerId, d.getUrl()))) {
                        d.setId(UUIDUtils.getInstance().generateShortUuid());
                        d.setDateCreated(new Timestamp(System.currentTimeMillis()));
                        d.setDateUpdated(new Timestamp(System.currentTimeMillis()));
                        this.discoveryUpstreamMapper.insert(DiscoveryTransfer.INSTANCE.mapToDo((DiscoveryUpstreamData)d));
                        LOGGER.info("shenyu [DiscoveryDataChangedEventSyncListener] ADDED Upstream {}", (Object)d.getUrl());
                    }
                });
                break;
            }
            case UPDATED: {
                upstreamDataList.stream().map(DiscoveryTransfer.INSTANCE::mapToDo).forEach(discoveryUpstreamDO -> {
                    discoveryUpstreamDO.setDiscoveryHandlerId(this.discoveryHandlerId);
                    int effect = this.discoveryUpstreamMapper.updateDiscoveryHandlerIdAndUrl((DiscoveryUpstreamDO)discoveryUpstreamDO);
                    LOGGER.info("shenyu [DiscoveryDataChangedEventSyncListener] UPDATE Upstream {}, effect = {} ", (Object)discoveryUpstreamDO.getUrl(), (Object)effect);
                });
                break;
            }
            case DELETED: {
                if (!CollectionUtils.isNotEmpty((Collection)upstreamDataList)) break;
                upstreamDataList.forEach(up -> {
                    this.discoveryUpstreamMapper.deleteByUrl(this.discoveryHandlerId, up.getUrl());
                    LOGGER.info("shenyu [DiscoveryDataChangedEventSyncListener] DELETE Upstream {}", (Object)up.getUrl());
                });
                break;
            }
            default: {
                throw new IllegalStateException("shenyu DiscoveryDataChangedEventSyncListener find IllegalState");
            }
        }
        this.fillFullyDiscoverySyncData(discoverySyncData);
        DataChangedEvent dataChangedEvent = new DataChangedEvent(ConfigGroupEnum.DISCOVER_UPSTREAM, DataEventTypeEnum.UPDATE, Collections.singletonList(discoverySyncData));
        this.eventPublisher.publishEvent((ApplicationEvent)dataChangedEvent);
    }

    private void fillFullyDiscoverySyncData(DiscoverySyncData discoverySyncData) {
        List<DiscoveryUpstreamDO> discoveryUpstreamDOS = this.discoveryUpstreamMapper.selectByProxySelectorId(discoverySyncData.getSelectorId());
        List collect = discoveryUpstreamDOS.stream().map(DiscoveryTransfer.INSTANCE::mapToData).collect(Collectors.toList());
        discoverySyncData.setUpstreamDataList(collect);
    }

    private DiscoverySyncData buildProxySelectorData(String value) {
        List<DiscoveryUpstreamData> discoveryUpstreamDTOS = this.keyValueParser.parseValue(value);
        discoveryUpstreamDTOS.forEach(s -> s.setDiscoveryHandlerId(this.discoveryHandlerId));
        DiscoverySyncData data = new DiscoverySyncData();
        data.setUpstreamDataList(discoveryUpstreamDTOS);
        data.setSelectorId(this.contextInfo.getSelectorId());
        data.setSelectorName(this.contextInfo.getSelectorName());
        data.setPluginName(this.contextInfo.getPluginName());
        return data;
    }
}

