/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import org.apache.shenyu.admin.listener.DataChangedListener;
import org.apache.shenyu.common.constant.DefaultPathConstants;
import org.apache.shenyu.common.dto.AppAuthData;
import org.apache.shenyu.common.dto.DiscoverySyncData;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.ProxySelectorData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNodeDataChangedListener
implements DataChangedListener {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNodeDataChangedListener.class);
    private final Object ruleSyncObject = new Object();
    private final Object selectorSyncObject = new Object();

    @Override
    public void onAppAuthChanged(List<AppAuthData> changed, DataEventTypeEnum eventType) {
        for (AppAuthData data : changed) {
            String appAuthPath = DefaultPathConstants.buildAppAuthPath((String)data.getAppKey());
            if (eventType == DataEventTypeEnum.DELETE) {
                this.deleteNode(appAuthPath);
                LOG.debug("[DataChangedListener] delete appKey {}", (Object)data.getAppKey());
                continue;
            }
            this.createOrUpdate(appAuthPath, data);
            LOG.debug("[DataChangedListener] change appKey {}", (Object)data.getAppKey());
        }
    }

    @Override
    public void onMetaDataChanged(List<MetaData> changed, DataEventTypeEnum eventType) {
        for (MetaData data : changed) {
            try {
                String metaDataPath = DefaultPathConstants.buildMetaDataPath((String)URLEncoder.encode(data.getPath(), "UTF-8"));
                if (eventType == DataEventTypeEnum.DELETE) {
                    this.deleteNode(metaDataPath);
                    LOG.debug("[DataChangedListener] delete appKey {}", (Object)metaDataPath);
                    continue;
                }
                this.createOrUpdate(metaDataPath, data);
                LOG.debug("[DataChangedListener] change metaDataPath {}", (Object)metaDataPath);
            }
            catch (UnsupportedEncodingException e) {
                LOG.error("[DataChangedListener] url encode error.", (Throwable)e);
                throw new ShenyuException(e.getMessage());
            }
        }
    }

    @Override
    public void onProxySelectorChanged(List<ProxySelectorData> changed, DataEventTypeEnum eventType) {
        for (ProxySelectorData data : changed) {
            String proxySelectorPath = DefaultPathConstants.buildProxySelectorPath((String)data.getPluginName(), (String)data.getName());
            if (eventType == DataEventTypeEnum.DELETE) {
                this.deleteNode(proxySelectorPath);
                LOG.debug("[DataChangedListener] delete appKey {}", (Object)proxySelectorPath);
                continue;
            }
            this.createOrUpdate(proxySelectorPath, data);
            LOG.info("[DataChangedListener] change proxySelector path={}|data={}", (Object)proxySelectorPath, (Object)data);
        }
    }

    @Override
    public void onDiscoveryUpstreamChanged(List<DiscoverySyncData> changed, DataEventTypeEnum eventType) {
        for (DiscoverySyncData data : changed) {
            String upstreamPath = DefaultPathConstants.buildDiscoveryUpstreamPath((String)data.getPluginName(), (String)data.getSelectorName());
            if (eventType == DataEventTypeEnum.DELETE) {
                this.deleteNode(upstreamPath);
                LOG.debug("[DataChangedListener] delete appKey {}", (Object)upstreamPath);
                continue;
            }
            this.createOrUpdate(upstreamPath, data);
            LOG.info("[DataChangedListener] change discoveryUpstream path={}|data={}", (Object)upstreamPath, (Object)data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSelectorChanged(List<SelectorData> changed, DataEventTypeEnum eventType) {
        if (eventType == DataEventTypeEnum.REFRESH && !changed.isEmpty()) {
            String selectorParentPath = DefaultPathConstants.buildSelectorParentPath((String)changed.get(0).getPluginName());
            this.deletePathRecursive(selectorParentPath);
        }
        for (SelectorData data : changed) {
            String selectorRealPath = DefaultPathConstants.buildSelectorRealPath((String)data.getPluginName(), (String)data.getId());
            if (eventType == DataEventTypeEnum.DELETE) {
                this.deleteNode(selectorRealPath);
                LOG.debug("[DataChangedListener] delete appKey {}", (Object)selectorRealPath);
                continue;
            }
            Object object = this.selectorSyncObject;
            synchronized (object) {
                this.createOrUpdate(selectorRealPath, data);
            }
            LOG.debug("[DataChangedListener] change path {} with data {}", (Object)selectorRealPath, (Object)data);
        }
    }

    @Override
    public void onPluginChanged(List<PluginData> changed, DataEventTypeEnum eventType) {
        for (PluginData data : changed) {
            String pluginPath = DefaultPathConstants.buildPluginPath((String)data.getName());
            if (eventType == DataEventTypeEnum.DELETE) {
                this.deletePathRecursive(pluginPath);
                String selectorParentPath = DefaultPathConstants.buildSelectorParentPath((String)data.getName());
                this.deletePathRecursive(selectorParentPath);
                String ruleParentPath = DefaultPathConstants.buildRuleParentPath((String)data.getName());
                this.deletePathRecursive(ruleParentPath);
                LOG.debug("[DataChangedListener] delete pluginPath {}", (Object)pluginPath);
                continue;
            }
            this.createOrUpdate(pluginPath, data);
            LOG.debug("[DataChangedListener] change path {} with data {}", (Object)pluginPath, (Object)data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRuleChanged(List<RuleData> changed, DataEventTypeEnum eventType) {
        if (eventType == DataEventTypeEnum.REFRESH && !changed.isEmpty()) {
            String selectorParentPath = DefaultPathConstants.buildRuleParentPath((String)changed.get(0).getPluginName());
            this.deletePathRecursive(selectorParentPath);
        }
        for (RuleData data : changed) {
            String ruleRealPath = DefaultPathConstants.buildRulePath((String)data.getPluginName(), (String)data.getSelectorId(), (String)data.getId());
            if (eventType == DataEventTypeEnum.DELETE) {
                this.deleteNode(ruleRealPath);
                continue;
            }
            Object object = this.ruleSyncObject;
            synchronized (object) {
                this.createOrUpdate(ruleRealPath, data);
            }
            LOG.debug("[DataChangedListener] change path {} with data {}", (Object)ruleRealPath, (Object)data);
        }
    }

    public abstract void createOrUpdate(String var1, Object var2);

    public abstract void deleteNode(String var1);

    public abstract void deletePathRecursive(String var1);
}

