/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.listener.DataChangedListener;
import org.apache.shenyu.admin.service.manager.LoadServiceDocEntry;
import org.apache.shenyu.common.dto.AppAuthData;
import org.apache.shenyu.common.dto.DiscoverySyncData;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.ProxySelectorData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class DataChangedEventDispatcher
implements ApplicationListener<DataChangedEvent>,
InitializingBean {
    private final ApplicationContext applicationContext;
    private List<DataChangedListener> listeners;

    public DataChangedEventDispatcher(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(DataChangedEvent event) {
        block9: for (DataChangedListener listener : this.listeners) {
            switch (event.getGroupKey()) {
                case APP_AUTH: {
                    listener.onAppAuthChanged((List<AppAuthData>)event.getSource(), event.getEventType());
                    continue block9;
                }
                case PLUGIN: {
                    listener.onPluginChanged((List<PluginData>)event.getSource(), event.getEventType());
                    continue block9;
                }
                case RULE: {
                    listener.onRuleChanged((List<RuleData>)event.getSource(), event.getEventType());
                    continue block9;
                }
                case SELECTOR: {
                    listener.onSelectorChanged((List<SelectorData>)event.getSource(), event.getEventType());
                    ((LoadServiceDocEntry)this.applicationContext.getBean(LoadServiceDocEntry.class)).loadDocOnSelectorChanged((List<SelectorData>)event.getSource(), event.getEventType());
                    continue block9;
                }
                case META_DATA: {
                    listener.onMetaDataChanged((List<MetaData>)event.getSource(), event.getEventType());
                    continue block9;
                }
                case PROXY_SELECTOR: {
                    listener.onProxySelectorChanged((List<ProxySelectorData>)event.getSource(), event.getEventType());
                    continue block9;
                }
                case DISCOVER_UPSTREAM: {
                    listener.onDiscoveryUpstreamChanged((List<DiscoverySyncData>)event.getSource(), event.getEventType());
                    continue block9;
                }
            }
            throw new IllegalStateException("Unexpected value: " + event.getGroupKey());
        }
    }

    public void afterPropertiesSet() {
        Collection listenerBeans = this.applicationContext.getBeansOfType(DataChangedListener.class).values();
        this.listeners = Collections.unmodifiableList(new ArrayList(listenerBeans));
    }
}

