/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener.nacos;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.shenyu.admin.listener.AbstractDataChangedInit;
import org.apache.shenyu.common.exception.ShenyuException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosDataChangedInit
extends AbstractDataChangedInit {
    private static final Logger LOG = LoggerFactory.getLogger(NacosDataChangedInit.class);
    private final ConfigService configService;

    public NacosDataChangedInit(ConfigService configService) {
        this.configService = configService;
    }

    @Override
    protected boolean notExist() {
        return Stream.of("shenyu.plugin.json", "shenyu.auth.json", "shenyu.meta.json", "shenyu.proxy.selector.json").allMatch(this::dataIdNotExist);
    }

    private boolean dataIdNotExist(String pluginDataId) {
        try {
            return Objects.isNull(this.configService.getConfig(pluginDataId, "DEFAULT_GROUP", 6000L));
        }
        catch (NacosException e) {
            LOG.error("Get data from nacos error.", (Throwable)e);
            throw new ShenyuException(e.getMessage());
        }
    }
}

