/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener.nacos;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.exception.NacosException;
import org.apache.shenyu.admin.listener.AbstractListDataChangedListener;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class NacosDataChangedListener
extends AbstractListDataChangedListener {
    private static final Logger LOG = LoggerFactory.getLogger(NacosDataChangedListener.class);
    private final ConfigService configService;

    public NacosDataChangedListener(ConfigService configService) {
        super(new AbstractListDataChangedListener.ChangeData("shenyu.plugin.json", "shenyu.selector.json", "shenyu.rule.json", "shenyu.auth.json", "shenyu.meta.json", "shenyu.proxy.selector.json", "shenyu.discovery.data.json"));
        this.configService = configService;
    }

    @Override
    public void publishConfig(String dataId, Object data) {
        try {
            this.configService.publishConfig(dataId, "DEFAULT_GROUP", GsonUtils.getInstance().toJson(data), ConfigType.JSON.getType());
        }
        catch (NacosException e) {
            LOG.error("Publish data to nacos error.", (Throwable)e);
            throw new ShenyuException(e.getMessage());
        }
    }

    @Override
    public String getConfig(String dataId) {
        try {
            String config = this.configService.getConfig(dataId, "DEFAULT_GROUP", 6000L);
            return StringUtils.hasLength((String)config) ? config : "{}";
        }
        catch (NacosException e) {
            LOG.error("Get data from nacos error.", (Throwable)e);
            throw new ShenyuException(e.getMessage());
        }
    }
}

