/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.entity;

import java.sql.Timestamp;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.AppAuthDTO;
import org.apache.shenyu.admin.model.dto.AuthApplyDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.common.utils.SignUtils;
import org.apache.shenyu.common.utils.UUIDUtils;

public final class AppAuthDO
extends BaseDO {
    private static final long serialVersionUID = 5683408559456006830L;
    private String appKey;
    private String appSecret;
    private Boolean enabled;
    private Boolean open;
    private String userId;
    private String phone;
    private String extInfo;

    public AppAuthDO() {
    }

    public AppAuthDO(String appKey, String appSecret, Boolean enabled, Boolean open, String userId, String phone, String extInfo) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.enabled = enabled;
        this.open = open;
        this.userId = userId;
        this.phone = phone;
        this.extInfo = extInfo;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getOpen() {
        return this.open;
    }

    public void setOpen(Boolean open) {
        this.open = open;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getExtInfo() {
        return this.extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

    public static AppAuthDO create(AppAuthDTO appAuthDTO) {
        return Optional.ofNullable(appAuthDTO).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            AppAuthDO appAuthDO = AppAuthDO.builder().appKey(item.getAppKey()).appSecret(item.getAppSecret()).open(item.getOpen()).enabled(item.getEnabled()).dateUpdated(currentTime).build();
            if (StringUtils.isEmpty((CharSequence)item.getId())) {
                appAuthDO.setId(UUIDUtils.getInstance().generateShortUuid());
                appAuthDO.setDateCreated(currentTime);
            } else {
                appAuthDO.setId(item.getId());
            }
            return appAuthDO;
        }).orElse(null);
    }

    public static AppAuthDO create(AuthApplyDTO authApplyDTO) {
        return Optional.ofNullable(authApplyDTO).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            return AppAuthDO.builder().id(UUIDUtils.getInstance().generateShortUuid()).userId(item.getUserId()).phone(item.getPhone()).extInfo(item.getExtInfo()).appKey(SignUtils.generateKey()).appSecret(SignUtils.generateKey()).open(item.getOpen()).enabled(true).dateCreated(currentTime).dateUpdated(currentTime).build();
        }).orElse(null);
    }

    public static AppAuthDOBuilder builder() {
        return new AppAuthDOBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AppAuthDO)) {
            return false;
        }
        AppAuthDO appAuthDO = (AppAuthDO)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.appKey.equals(appAuthDO.appKey) && this.appSecret.equals(appAuthDO.appSecret) && this.enabled.equals(appAuthDO.enabled) && this.open.equals(appAuthDO.open) && this.userId.equals(appAuthDO.userId) && this.phone.equals(appAuthDO.phone) && this.extInfo.equals(appAuthDO.extInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.appKey, this.appSecret, this.enabled, this.open, this.userId, this.phone, this.extInfo);
    }

    public static final class AppAuthDOBuilder {
        private String appKey;
        private String appSecret;
        private Boolean enabled;
        private Boolean open;
        private String userId;
        private String phone;
        private String extInfo;
        private String id;
        private Timestamp dateCreated;
        private Timestamp dateUpdated;

        private AppAuthDOBuilder() {
        }

        public AppAuthDOBuilder appKey(String appKey) {
            this.appKey = appKey;
            return this;
        }

        public AppAuthDOBuilder appSecret(String appSecret) {
            this.appSecret = appSecret;
            return this;
        }

        public AppAuthDOBuilder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public AppAuthDOBuilder open(Boolean open) {
            this.open = open;
            return this;
        }

        public AppAuthDOBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public AppAuthDOBuilder phone(String phone) {
            this.phone = phone;
            return this;
        }

        public AppAuthDOBuilder extInfo(String extInfo) {
            this.extInfo = extInfo;
            return this;
        }

        public AppAuthDOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public AppAuthDOBuilder dateCreated(Timestamp dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public AppAuthDOBuilder dateUpdated(Timestamp dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public AppAuthDO build() {
            AppAuthDO appAuthDO = new AppAuthDO();
            appAuthDO.setAppKey(this.appKey);
            appAuthDO.setAppSecret(this.appSecret);
            appAuthDO.setEnabled(this.enabled);
            appAuthDO.setOpen(this.open);
            appAuthDO.setUserId(this.userId);
            appAuthDO.setPhone(this.phone);
            appAuthDO.setExtInfo(this.extInfo);
            appAuthDO.setId(this.id);
            appAuthDO.setDateCreated(this.dateCreated);
            appAuthDO.setDateUpdated(this.dateUpdated);
            return appAuthDO;
        }
    }
}

