/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.entity;

import java.sql.Timestamp;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.RoleDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.common.utils.UUIDUtils;

public final class RoleDO
extends BaseDO {
    private static final long serialVersionUID = -7319631396664845158L;
    private String roleName;
    private String description;

    public RoleDO() {
    }

    public RoleDO(String roleName, String description) {
        this.roleName = roleName;
        this.description = description;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static RoleDOBuilder builder() {
        return new RoleDOBuilder();
    }

    public static RoleDO buildRoleDO(RoleDTO roleDTO) {
        return Optional.ofNullable(roleDTO).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            RoleDO roleDO = RoleDO.builder().roleName(item.getRoleName()).description(item.getDescription()).dateUpdated(currentTime).build();
            if (StringUtils.isEmpty((CharSequence)item.getId())) {
                roleDO.setId(UUIDUtils.getInstance().generateShortUuid());
                roleDO.setDateCreated(currentTime);
            } else {
                roleDO.setId(item.getId());
            }
            return roleDO;
        }).orElse(null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RoleDO roleDO = (RoleDO)o;
        return Objects.equals(this.roleName, roleDO.roleName) && Objects.equals(this.description, roleDO.description);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.roleName, this.description);
    }

    public static final class RoleDOBuilder {
        private String id;
        private Timestamp dateCreated;
        private Timestamp dateUpdated;
        private String roleName;
        private String description;

        private RoleDOBuilder() {
        }

        public RoleDOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public RoleDOBuilder dateCreated(Timestamp dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public RoleDOBuilder dateUpdated(Timestamp dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public RoleDOBuilder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public RoleDOBuilder description(String description) {
            this.description = description;
            return this;
        }

        public RoleDO build() {
            RoleDO roleDO = new RoleDO();
            roleDO.setId(this.id);
            roleDO.setDateCreated(this.dateCreated);
            roleDO.setDateUpdated(this.dateUpdated);
            roleDO.setRoleName(this.roleName);
            roleDO.setDescription(this.description);
            return roleDO;
        }
    }
}

