/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.event.resource;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.ResourceDO;
import org.apache.shenyu.admin.model.enums.EventTypeEnum;
import org.apache.shenyu.admin.model.event.BatchChangedEvent;
import org.apache.shenyu.common.utils.ListUtil;

public class BatchResourceCreatedEvent
extends BatchChangedEvent {
    private final List<String> deletedIds;

    public BatchResourceCreatedEvent(Collection<ResourceDO> source, String operator) {
        super(source, null, EventTypeEnum.RESOURCE_CREATE, operator);
        this.deletedIds = ListUtil.map(source, BaseDO::getId);
    }

    @Override
    public String buildContext() {
        String selector = ((Collection)this.getSource()).stream().map(s -> ((ResourceDO)s).getTitle()).collect(Collectors.joining(","));
        return String.format("the resource[%s] is %s", selector, StringUtils.lowerCase((String)this.getType().getType().toString()));
    }

    public List<ResourceDO> getResource() {
        return ((Collection)this.getSource()).stream().map(ResourceDO.class::cast).collect(Collectors.toList());
    }

    public List<String> getDeletedIds() {
        return this.deletedIds;
    }
}

