/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.sql.Timestamp;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.discovery.DiscoveryProcessor;
import org.apache.shenyu.admin.discovery.DiscoveryProcessorHolder;
import org.apache.shenyu.admin.mapper.DiscoveryHandlerMapper;
import org.apache.shenyu.admin.mapper.DiscoveryMapper;
import org.apache.shenyu.admin.mapper.ProxySelectorMapper;
import org.apache.shenyu.admin.model.dto.DiscoveryDTO;
import org.apache.shenyu.admin.model.dto.ProxySelectorDTO;
import org.apache.shenyu.admin.model.entity.DiscoveryDO;
import org.apache.shenyu.admin.model.entity.DiscoveryHandlerDO;
import org.apache.shenyu.admin.model.enums.DiscoveryTypeEnum;
import org.apache.shenyu.admin.model.vo.DiscoveryVO;
import org.apache.shenyu.admin.service.DiscoveryService;
import org.apache.shenyu.admin.transfer.DiscoveryTransfer;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DiscoveryServiceImpl
implements DiscoveryService {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryServiceImpl.class);
    private final DiscoveryMapper discoveryMapper;
    private final ProxySelectorMapper proxySelectorMapper;
    private final DiscoveryHandlerMapper discoveryHandlerMapper;
    private final DiscoveryProcessorHolder discoveryProcessorHolder;

    public DiscoveryServiceImpl(DiscoveryMapper discoveryMapper, ProxySelectorMapper proxySelectorMapper, DiscoveryHandlerMapper discoveryHandlerMapper, DiscoveryProcessorHolder discoveryProcessorHolder) {
        this.discoveryMapper = discoveryMapper;
        this.discoveryProcessorHolder = discoveryProcessorHolder;
        this.proxySelectorMapper = proxySelectorMapper;
        this.discoveryHandlerMapper = discoveryHandlerMapper;
    }

    @Override
    public List<String> typeEnums() {
        return DiscoveryTypeEnum.types();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public DiscoveryVO discovery(String pluginName, String level) {
        return this.discoveryVO(this.discoveryMapper.selectByPluginNameAndLevel(pluginName, level));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public DiscoveryVO createOrUpdate(DiscoveryDTO discoveryDTO) {
        return StringUtils.isBlank((CharSequence)discoveryDTO.getId()) ? this.create(discoveryDTO) : this.update(discoveryDTO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String delete(String discoveryId) {
        List<DiscoveryHandlerDO> discoveryHandlerDOS = this.discoveryHandlerMapper.selectByDiscoveryId(discoveryId);
        if (CollectionUtils.isNotEmpty(discoveryHandlerDOS)) {
            LOG.warn("shenyu this discovery has discoveryHandler can't be delete");
            throw new ShenyuException("shenyu this discovery has discoveryHandler can't be delete");
        }
        DiscoveryDO discoveryDO = this.discoveryMapper.selectById(discoveryId);
        DiscoveryProcessor discoveryProcessor = this.discoveryProcessorHolder.chooseProcessor(discoveryDO.getType());
        discoveryProcessor.removeDiscovery(discoveryDO);
        this.discoveryMapper.delete(discoveryId);
        return "delete success";
    }

    private DiscoveryVO create(DiscoveryDTO discoveryDTO) {
        if (discoveryDTO == null) {
            return null;
        }
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        DiscoveryDO discoveryDO = DiscoveryDO.builder().id(discoveryDTO.getId()).name(discoveryDTO.getName()).pluginName(discoveryDTO.getPluginName()).level(discoveryDTO.getLevel()).type(discoveryDTO.getType()).serverList(discoveryDTO.getServerList()).props(discoveryDTO.getProps()).dateCreated(currentTime).dateUpdated(currentTime).build();
        if (StringUtils.isEmpty((CharSequence)discoveryDTO.getId())) {
            discoveryDO.setId(UUIDUtils.getInstance().generateShortUuid());
        }
        DiscoveryProcessor discoveryProcessor = this.discoveryProcessorHolder.chooseProcessor(discoveryDO.getType());
        DiscoveryVO result = this.discoveryMapper.insert(discoveryDO) > 0 ? this.discoveryVO(discoveryDO) : null;
        discoveryProcessor.createDiscovery(discoveryDO);
        return result;
    }

    private DiscoveryVO update(DiscoveryDTO discoveryDTO) {
        if (discoveryDTO == null || discoveryDTO.getId() == null) {
            return null;
        }
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        DiscoveryDO discoveryDO = DiscoveryDO.builder().id(discoveryDTO.getId()).name(discoveryDTO.getName()).type(discoveryDTO.getType()).serverList(discoveryDTO.getServerList()).props(discoveryDTO.getProps()).dateUpdated(currentTime).build();
        return this.discoveryMapper.updateSelective(discoveryDO) > 0 ? this.discoveryVO(discoveryDO) : null;
    }

    private DiscoveryVO discoveryVO(DiscoveryDO discoveryDO) {
        if (discoveryDO == null) {
            return null;
        }
        DiscoveryVO discoveryVO = new DiscoveryVO();
        BeanUtils.copyProperties((Object)discoveryDO, (Object)discoveryVO);
        return discoveryVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncData() {
        LOG.info("shenyu DiscoveryService sync db ");
        List<DiscoveryDO> discoveryDOS = this.discoveryMapper.selectAll();
        discoveryDOS.forEach(d -> {
            DiscoveryProcessor discoveryProcessor = this.discoveryProcessorHolder.chooseProcessor(d.getType());
            discoveryProcessor.createDiscovery((DiscoveryDO)d);
            this.proxySelectorMapper.selectByDiscoveryId(d.getId()).stream().map(DiscoveryTransfer.INSTANCE::mapToDTO).forEach(ps -> {
                DiscoveryHandlerDO discoveryHandlerDO = this.discoveryHandlerMapper.selectByProxySelectorId(ps.getId());
                discoveryProcessor.createProxySelector(DiscoveryTransfer.INSTANCE.mapToDTO(discoveryHandlerDO), (ProxySelectorDTO)ps);
                discoveryProcessor.fetchAll(discoveryHandlerDO.getId());
            });
        });
    }
}

