/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.shenyu.admin.discovery.DiscoveryProcessor;
import org.apache.shenyu.admin.discovery.DiscoveryProcessorHolder;
import org.apache.shenyu.admin.mapper.DiscoveryHandlerMapper;
import org.apache.shenyu.admin.mapper.DiscoveryMapper;
import org.apache.shenyu.admin.mapper.DiscoveryRelMapper;
import org.apache.shenyu.admin.mapper.DiscoveryUpstreamMapper;
import org.apache.shenyu.admin.mapper.ProxySelectorMapper;
import org.apache.shenyu.admin.mapper.SelectorMapper;
import org.apache.shenyu.admin.model.dto.DiscoveryUpstreamDTO;
import org.apache.shenyu.admin.model.entity.DiscoveryDO;
import org.apache.shenyu.admin.model.entity.DiscoveryHandlerDO;
import org.apache.shenyu.admin.model.entity.DiscoveryRelDO;
import org.apache.shenyu.admin.model.entity.DiscoveryUpstreamDO;
import org.apache.shenyu.admin.model.entity.ProxySelectorDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.service.DiscoveryUpstreamService;
import org.apache.shenyu.admin.transfer.DiscoveryTransfer;
import org.apache.shenyu.common.dto.DiscoverySyncData;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DiscoveryUpstreamServiceImpl
implements DiscoveryUpstreamService {
    private final DiscoveryUpstreamMapper discoveryUpstreamMapper;
    private final DiscoveryHandlerMapper discoveryHandlerMapper;
    private final DiscoveryRelMapper discoveryRelMapper;
    private final ProxySelectorMapper proxySelectorMapper;
    private final DiscoveryMapper discoveryMapper;
    private final SelectorMapper selectorMapper;
    private final DiscoveryProcessorHolder discoveryProcessorHolder;

    public DiscoveryUpstreamServiceImpl(DiscoveryUpstreamMapper discoveryUpstreamMapper, DiscoveryHandlerMapper discoveryHandlerMapper, ProxySelectorMapper proxySelectorMapper, DiscoveryMapper discoveryMapper, DiscoveryRelMapper discoveryRelMapper, SelectorMapper selectorMapper, DiscoveryProcessorHolder discoveryProcessorHolder) {
        this.discoveryUpstreamMapper = discoveryUpstreamMapper;
        this.discoveryProcessorHolder = discoveryProcessorHolder;
        this.discoveryHandlerMapper = discoveryHandlerMapper;
        this.discoveryMapper = discoveryMapper;
        this.discoveryRelMapper = discoveryRelMapper;
        this.selectorMapper = selectorMapper;
        this.proxySelectorMapper = proxySelectorMapper;
    }

    @Override
    public String createOrUpdate(DiscoveryUpstreamDTO discoveryUpstreamDTO) {
        return StringUtils.hasLength((String)discoveryUpstreamDTO.getId()) ? this.update(discoveryUpstreamDTO) : this.create(discoveryUpstreamDTO);
    }

    @Override
    public String delete(List<String> ids) {
        this.discoveryUpstreamMapper.deleteByIds(ids);
        return "delete success";
    }

    @Override
    public List<DiscoverySyncData> listAll() {
        List<DiscoveryHandlerDO> discoveryHandlerDOS = this.discoveryHandlerMapper.selectAll();
        return discoveryHandlerDOS.stream().map(d -> {
            DiscoveryRelDO discoveryRelDO = this.discoveryRelMapper.selectByDiscoveryHandlerId(d.getId());
            DiscoverySyncData discoverySyncData = new DiscoverySyncData();
            discoverySyncData.setPluginName(discoveryRelDO.getPluginName());
            if (StringUtils.hasLength((String)discoveryRelDO.getSelectorId())) {
                String selectorId = discoveryRelDO.getSelectorId();
                discoverySyncData.setSelectorId(selectorId);
                SelectorDO selectorDO = this.selectorMapper.selectById(selectorId);
                discoverySyncData.setSelectorName(selectorDO.getName());
            } else {
                String proxySelectorId = discoveryRelDO.getProxySelectorId();
                discoverySyncData.setSelectorId(proxySelectorId);
                ProxySelectorDO proxySelectorDO = this.proxySelectorMapper.selectById(proxySelectorId);
                discoverySyncData.setSelectorName(proxySelectorDO.getName());
            }
            List discoveryUpstreamDataList = this.discoveryUpstreamMapper.selectByDiscoveryHandlerId(d.getId()).stream().map(DiscoveryTransfer.INSTANCE::mapToData).collect(Collectors.toList());
            discoverySyncData.setUpstreamDataList(discoveryUpstreamDataList);
            return discoverySyncData;
        }).collect(Collectors.toList());
    }

    private String create(DiscoveryUpstreamDTO discoveryUpstreamDTO) {
        DiscoveryUpstreamDO discoveryUpstreamDO = DiscoveryUpstreamDO.buildDiscoveryUpstreamDO(discoveryUpstreamDTO);
        this.discoveryUpstreamMapper.insert(discoveryUpstreamDO);
        this.fetchAll(discoveryUpstreamDTO.getDiscoveryHandlerId());
        return "create success";
    }

    private String update(DiscoveryUpstreamDTO discoveryUpstreamDTO) {
        DiscoveryUpstreamDO discoveryUpstreamDO = DiscoveryUpstreamDO.buildDiscoveryUpstreamDO(discoveryUpstreamDTO);
        this.discoveryUpstreamMapper.update(discoveryUpstreamDO);
        this.fetchAll(discoveryUpstreamDTO.getDiscoveryHandlerId());
        return "update success";
    }

    private void fetchAll(String discoveryHandlerId) {
        List<DiscoveryUpstreamDO> discoveryUpstreamDOS = this.discoveryUpstreamMapper.selectByDiscoveryHandlerId(discoveryHandlerId);
        DiscoveryHandlerDO discoveryHandlerDO = this.discoveryHandlerMapper.selectById(discoveryHandlerId);
        ProxySelectorDO proxySelectorDO = this.proxySelectorMapper.selectByHandlerId(discoveryHandlerId);
        DiscoveryDO discoveryDO = this.discoveryMapper.selectById(discoveryHandlerDO.getDiscoveryId());
        List<DiscoveryUpstreamDTO> collect = discoveryUpstreamDOS.stream().map(DiscoveryTransfer.INSTANCE::mapToDTO).collect(Collectors.toList());
        DiscoveryProcessor discoveryProcessor = this.discoveryProcessorHolder.chooseProcessor(discoveryDO.getType());
        discoveryProcessor.changeUpstream(DiscoveryTransfer.INSTANCE.mapToDTO(proxySelectorDO), collect);
    }
}

