/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.aspect.annotation.Pageable;
import org.apache.shenyu.admin.mapper.ShenyuDictMapper;
import org.apache.shenyu.admin.model.dto.ShenyuDictDTO;
import org.apache.shenyu.admin.model.entity.ShenyuDictDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.ShenyuDictQuery;
import org.apache.shenyu.admin.model.vo.ShenyuDictVO;
import org.apache.shenyu.admin.service.ShenyuDictService;
import org.apache.shenyu.admin.service.publish.DictEventPublisher;
import org.apache.shenyu.admin.utils.Assert;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShenyuDictServiceImpl
implements ShenyuDictService {
    private final ShenyuDictMapper shenyuDictMapper;
    private final DictEventPublisher publisher;

    public ShenyuDictServiceImpl(ShenyuDictMapper shenyuDictMapper, DictEventPublisher publisher) {
        this.shenyuDictMapper = shenyuDictMapper;
        this.publisher = publisher;
    }

    @Override
    @Pageable
    public CommonPager<ShenyuDictVO> listByPage(ShenyuDictQuery shenyuDictQuery) {
        return PageResultUtils.result(shenyuDictQuery.getPageParameter(), () -> this.shenyuDictMapper.selectByQuery(shenyuDictQuery).stream().map(ShenyuDictVO::buildShenyuDictVO).collect(Collectors.toList()));
    }

    @Override
    public Integer createOrUpdate(ShenyuDictDTO shenyuDictDTO) {
        return StringUtils.isBlank((CharSequence)shenyuDictDTO.getId()) ? this.create(shenyuDictDTO) : this.update(shenyuDictDTO);
    }

    private int update(ShenyuDictDTO shenyuDictDTO) {
        ShenyuDictDO before = this.shenyuDictMapper.selectById(shenyuDictDTO.getId());
        Assert.notNull(before, "the dict is not existed");
        ShenyuDictDO dict = ShenyuDictDO.buildShenyuDictDO(shenyuDictDTO);
        int changeCount = this.shenyuDictMapper.updateByPrimaryKeySelective(dict);
        if (changeCount > 0) {
            this.publisher.onUpdated(dict, before);
        }
        return changeCount;
    }

    private int create(ShenyuDictDTO shenyuDictDTO) {
        ShenyuDictDO dict = ShenyuDictDO.buildShenyuDictDO(shenyuDictDTO);
        int insertCount = this.shenyuDictMapper.insertSelective(dict);
        if (insertCount > 0) {
            this.publisher.onCreated(dict);
        }
        return insertCount;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer deleteShenyuDicts(List<String> ids) {
        List<ShenyuDictDO> dictList = this.shenyuDictMapper.selectByIds(ids);
        int deleteCount = this.shenyuDictMapper.deleteByIdList(ids);
        if (deleteCount > 0) {
            this.publisher.onDeleted((Collection<ShenyuDictDO>)dictList);
        }
        return deleteCount;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer enabled(List<String> ids, Boolean enabled) {
        return this.shenyuDictMapper.enabled(ids, enabled);
    }

    @Override
    public ShenyuDictVO findById(String id) {
        return ShenyuDictVO.buildShenyuDictVO(this.shenyuDictMapper.selectById(id));
    }

    @Override
    public ShenyuDictVO findByDictCodeName(String dictCode, String dictName) {
        return ShenyuDictVO.buildShenyuDictVO(this.shenyuDictMapper.selectByDictCodeAndDictName(dictCode, dictName));
    }

    @Override
    public List<ShenyuDictVO> list(String type) {
        ShenyuDictQuery shenyuDictQuery = new ShenyuDictQuery();
        shenyuDictQuery.setType(type);
        return this.shenyuDictMapper.selectByQuery(shenyuDictQuery).stream().map(ShenyuDictVO::buildShenyuDictVO).collect(Collectors.toList());
    }
}

