/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.manager.impl;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.shenyu.admin.model.bean.UpstreamInstance;
import org.apache.shenyu.admin.model.dto.TagDTO;
import org.apache.shenyu.admin.model.entity.TagDO;
import org.apache.shenyu.admin.model.vo.TagVO;
import org.apache.shenyu.admin.service.TagService;
import org.apache.shenyu.admin.service.manager.DocManager;
import org.apache.shenyu.admin.service.manager.PullSwaggerDocService;
import org.apache.shenyu.admin.utils.HttpUtils;
import org.apache.shenyu.common.utils.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PullSwaggerDocServiceImpl
implements PullSwaggerDocService {
    private static final Logger LOG = LoggerFactory.getLogger(PullSwaggerDocServiceImpl.class);
    private static final HttpUtils HTTP_UTILS = new HttpUtils();
    private static final String SWAGGER_V2_PATH = "/v2/api-docs";
    private static final long PULL_MIN_INTERVAL_TIME = 30000L;
    private static final long DOC_LOCK_EXPIRED_TIME = 60000L;
    private final Interner<Object> interner = Interners.newWeakInterner();
    @Resource
    private DocManager docManager;
    @Resource
    private TagService tagService;

    @Override
    public void pullApiDocument(Set<UpstreamInstance> currentServices) {
        currentServices.forEach(this::pullApiDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pullApiDocument(UpstreamInstance instance) {
        TagVO tagVO = null;
        Object object = this.interner.intern((Object)instance.getClusterName());
        synchronized (object) {
            tagVO = this.saveTagVOAndAcquireLock(instance);
            if (!this.canPull(instance, tagVO)) {
                LOG.info("api document has been pulled and cannot be pulled again\uff0cinstance: {}", (Object)instance.getClusterName());
                return;
            }
        }
        TagDO.TagExt tagExt = tagVO.getTagExt();
        long newRefreshTime = System.currentTimeMillis();
        String url = this.getSwaggerRequestUrl(instance);
        try {
            String body = HTTP_UTILS.get(url, Collections.EMPTY_MAP);
            this.docManager.addDocInfo(instance, body, tagExt.getApiDocMd5(), callback -> {
                LOG.info("save api document successful\uff0cclusterName={}, ipPort={}", (Object)instance.getClusterName(), (Object)(instance.getIp() + ":" + instance.getPort()));
                tagExt.setApiDocMd5(callback.getDocMd5());
            });
            tagExt.setRefreshTime(newRefreshTime);
        }
        catch (Exception e) {
            LOG.error("add api document fail. clusterName={} url={} error={}", new Object[]{instance.getClusterName(), url, e});
        }
        finally {
            tagExt.setDocLock(null);
            this.tagService.updateTagExt(tagVO.getId(), tagExt);
        }
    }

    private boolean canPull(UpstreamInstance instance, TagVO tagVO) {
        boolean canPull = false;
        if (Objects.isNull(tagVO) || Objects.isNull(tagVO.getTagExt()) || StringUtils.isEmpty((CharSequence)tagVO.getTagExt().getDocLock())) {
            LOG.info("Unable to obtain lock for {}, retry after {} seconds.", (Object)instance.getClusterName(), (Object)60L);
            return false;
        }
        Long cacheLastStartUpTime = tagVO.getTagExt().getRefreshTime();
        if (Objects.isNull(cacheLastStartUpTime) || instance.getStartupTime() > cacheLastStartUpTime + 30000L) {
            canPull = true;
        }
        return canPull;
    }

    private TagVO saveTagVOAndAcquireLock(UpstreamInstance instance) {
        List<TagVO> tagVOList = this.tagService.findByQuery(instance.getContextPath(), "0");
        if (CollectionUtils.isNotEmpty(tagVOList)) {
            TagVO tagVO = tagVOList.get(0);
            TagDO.TagExt tagExt = this.convertTagExt(tagVO.getExt());
            tagVO.setTagExt(tagExt);
            if (StringUtils.isNotEmpty((CharSequence)tagExt.getDocLock()) && NumberUtils.toLong((String)tagExt.getDocLock(), (long)0L) > System.currentTimeMillis()) {
                tagExt.setDocLock(null);
                return tagVO;
            }
            tagExt.setDocLock(this.generateDocLock());
            this.tagService.updateTagExt(tagVO.getId(), tagExt);
            return tagVO;
        }
        return this.createRootTagAndAcquireLock(instance);
    }

    private TagVO createRootTagAndAcquireLock(UpstreamInstance instance) {
        TagDTO tagDTO = new TagDTO();
        tagDTO.setTagDesc(instance.getClusterName());
        tagDTO.setName(instance.getContextPath());
        tagDTO.setParentTagId("0");
        TagDO.TagExt tagExt = new TagDO.TagExt();
        tagExt.setDocLock(this.generateDocLock());
        this.tagService.createRootTag(tagDTO, tagExt);
        TagVO tagVO = new TagVO();
        tagVO.setId(tagDTO.getId());
        tagVO.setTagExt(tagExt);
        return tagVO;
    }

    private String generateDocLock() {
        return String.valueOf(System.currentTimeMillis() + 60000L);
    }

    private TagDO.TagExt convertTagExt(String ext) {
        return StringUtils.isNotEmpty((CharSequence)ext) ? (TagDO.TagExt)GsonUtils.getInstance().fromJson(ext, TagDO.TagExt.class) : new TagDO.TagExt();
    }

    private String getSwaggerRequestUrl(UpstreamInstance instance) {
        return "http://" + instance.getIp() + ":" + instance.getPort() + SWAGGER_V2_PATH;
    }
}

