/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.publish;

import java.util.Collection;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.model.entity.MetaDataDO;
import org.apache.shenyu.admin.model.enums.EventTypeEnum;
import org.apache.shenyu.admin.model.event.AdminDataModelChangedEvent;
import org.apache.shenyu.admin.model.event.metadata.BatchMetaDataChangedEvent;
import org.apache.shenyu.admin.model.event.metadata.BatchMetaDataDeletedEvent;
import org.apache.shenyu.admin.model.event.metadata.MetaDataCreatedEvent;
import org.apache.shenyu.admin.model.event.metadata.MetadataUpdatedEvent;
import org.apache.shenyu.admin.service.publish.AdminDataModelChangedEventPublisher;
import org.apache.shenyu.admin.transfer.MetaDataTransfer;
import org.apache.shenyu.admin.utils.SessionUtil;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.utils.ListUtil;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class MetaDataEventPublisher
implements AdminDataModelChangedEventPublisher<MetaDataDO> {
    private final ApplicationEventPublisher publisher;

    public MetaDataEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Override
    public void onCreated(MetaDataDO selector) {
        this.publish(new MetaDataCreatedEvent(selector, SessionUtil.visitorName()));
    }

    @Override
    public void onUpdated(MetaDataDO selector, MetaDataDO before) {
        this.publish(new MetadataUpdatedEvent(selector, before, SessionUtil.visitorName()));
    }

    @Override
    public void onDeleted(Collection<MetaDataDO> data) {
        this.publish(new BatchMetaDataDeletedEvent(data, SessionUtil.visitorName()));
        this.publisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.META_DATA, DataEventTypeEnum.DELETE, ListUtil.map(data, MetaDataTransfer.INSTANCE::mapToData)));
    }

    public void onEnabled(Collection<MetaDataDO> metaData) {
        this.publish(new BatchMetaDataChangedEvent(metaData, null, EventTypeEnum.META_DATA_UPDATE, SessionUtil.visitorName()));
        this.publisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.META_DATA, DataEventTypeEnum.UPDATE, ListUtil.map(metaData, MetaDataTransfer.INSTANCE::mapToData)));
    }

    @Override
    public void publish(AdminDataModelChangedEvent event) {
        this.publisher.publishEvent((ApplicationEvent)event);
    }
}

