/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.register;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.shenyu.admin.service.register.ShenyuClientRegisterService;
import org.apache.shenyu.common.timer.AbstractRetryTask;
import org.apache.shenyu.common.timer.Timer;
import org.apache.shenyu.common.timer.TimerTask;
import org.apache.shenyu.common.timer.WheelTimerFactory;
import org.apache.shenyu.common.utils.PluginNameAdapter;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FallbackShenyuClientRegisterService
implements ShenyuClientRegisterService {
    private final Logger logger = LoggerFactory.getLogger(FallbackShenyuClientRegisterService.class);
    private final Map<String, FallbackHolder> fallsRegisters = new ConcurrentHashMap<String, FallbackHolder>();
    private final Timer timer = WheelTimerFactory.getSharedTimer();

    protected FallbackShenyuClientRegisterService() {
    }

    @Override
    public String registerURI(String selectorName, List<URIRegisterDTO> uriList) {
        String result;
        String key = this.key(selectorName);
        try {
            this.removeFallBack(key);
            result = this.doRegisterURI(selectorName, uriList);
            this.logger.info("Register success: {},{}", (Object)selectorName, uriList);
        }
        catch (Exception ex) {
            this.logger.warn("Register exception: cause:{}", (Object)ex.getMessage());
            result = "";
            this.addFallback(key, new FallbackHolder(selectorName, uriList));
        }
        return result;
    }

    private void addFallback(String key, FallbackHolder holder) {
        FallbackHolder oldObj = this.fallsRegisters.get(key);
        if (Objects.nonNull(oldObj)) {
            return;
        }
        FallbackRegisterTask registryTask = new FallbackRegisterTask(key, this);
        this.fallsRegisters.put(key, holder);
        this.timer.add((TimerTask)registryTask);
        this.logger.info("Add to Fallback and wait for execution, {}:{}", (Object)holder.getSelectorName(), holder.getUriList());
    }

    private void removeFallBack(String key) {
        this.fallsRegisters.remove(key);
    }

    private void recover(String key) {
        FallbackHolder fallbackHolder = this.fallsRegisters.get(key);
        if (Objects.nonNull(fallbackHolder)) {
            List<URIRegisterDTO> uriList = fallbackHolder.getUriList();
            String selectorName = fallbackHolder.getSelectorName();
            this.doRegisterURI(selectorName, uriList);
            this.logger.info("Register success: {},{}", (Object)selectorName, uriList);
        }
    }

    private String key(String selectorName) {
        return String.join((CharSequence)":", selectorName, PluginNameAdapter.rpcTypeAdapter((String)this.rpcType()));
    }

    abstract String doRegisterURI(String var1, List<URIRegisterDTO> var2);

    private static final class FallbackRegisterTask
    extends AbstractRetryTask {
        private final FallbackShenyuClientRegisterService registerService;

        FallbackRegisterTask(String key, FallbackShenyuClientRegisterService registerService) {
            super(key, TimeUnit.SECONDS.toMillis(5L), Integer.valueOf(-1));
            this.registerService = registerService;
        }

        protected void doRetry(String key, TimerTask timerTask) {
            this.registerService.recover(key);
            this.registerService.removeFallBack(key);
        }
    }

    private static final class FallbackHolder {
        private final String selectorName;
        private final List<URIRegisterDTO> uriList;

        FallbackHolder(String selectorName, List<URIRegisterDTO> uriList) {
            this.selectorName = selectorName;
            this.uriList = uriList;
        }

        public String getSelectorName() {
            return this.selectorName;
        }

        public List<URIRegisterDTO> getUriList() {
            return this.uriList;
        }
    }
}

