/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.register;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.model.entity.MetaDataDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.service.MetaDataService;
import org.apache.shenyu.admin.service.SelectorService;
import org.apache.shenyu.admin.service.converter.DivideSelectorHandleConverter;
import org.apache.shenyu.admin.service.register.AbstractContextPathRegisterService;
import org.apache.shenyu.admin.utils.CommonUpstreamUtils;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.impl.DivideRuleHandle;
import org.apache.shenyu.common.dto.convert.selector.DivideUpstream;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.PluginNameAdapter;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.enums.EventType;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;

@Service
public class ShenyuClientRegisterDivideServiceImpl
extends AbstractContextPathRegisterService {
    @Resource
    private DivideSelectorHandleConverter divideSelectorHandleConverter;

    @Override
    public String rpcType() {
        return RpcTypeEnum.HTTP.getName();
    }

    @Override
    protected String selectorHandler(MetaDataRegisterDTO metaDataDTO) {
        return "";
    }

    @Override
    protected String ruleHandler() {
        return new DivideRuleHandle().toJson();
    }

    @Override
    protected void registerMetadata(MetaDataRegisterDTO dto) {
        if (dto.isRegisterMetaData()) {
            MetaDataService metaDataService = this.getMetaDataService();
            MetaDataDO exist = metaDataService.findByPath(dto.getPath());
            metaDataService.saveOrUpdateMetaData(exist, dto);
        }
    }

    @Override
    protected String buildHandle(List<URIRegisterDTO> uriList, SelectorDO selectorDO) {
        List existList;
        boolean isEventDeleted;
        List<DivideUpstream> addList = this.buildDivideUpstreamList(uriList);
        List<Object> canAddList = new CopyOnWriteArrayList();
        boolean bl = isEventDeleted = uriList.size() == 1 && EventType.DELETED.equals((Object)uriList.get(0).getEventType());
        if (isEventDeleted) {
            addList.get(0).setStatus(false);
        }
        if (CollectionUtils.isEmpty((Collection)(existList = GsonUtils.getInstance().fromCurrentList(selectorDO.getHandle(), DivideUpstream.class)))) {
            canAddList = addList;
        } else {
            List diffStatusList;
            List diffList = addList.stream().filter(upstream -> !existList.contains(upstream)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(diffList)) {
                canAddList.addAll(diffList);
                existList.addAll(diffList);
            }
            if (CollectionUtils.isNotEmpty(diffStatusList = addList.stream().filter(upstream -> !upstream.isStatus() || existList.stream().anyMatch(e -> e.equals(upstream) && e.isStatus() != upstream.isStatus())).collect(Collectors.toList()))) {
                canAddList.addAll(diffStatusList);
            }
        }
        if (this.doSubmit(selectorDO.getId(), canAddList)) {
            return null;
        }
        return GsonUtils.getInstance().toJson(CollectionUtils.isEmpty((Collection)existList) ? canAddList : existList);
    }

    private List<DivideUpstream> buildDivideUpstreamList(List<URIRegisterDTO> uriList) {
        return uriList.stream().map(dto -> CommonUpstreamUtils.buildDivideUpstream(dto.getProtocol(), dto.getHost(), dto.getPort())).collect(Collectors.toCollection(CopyOnWriteArrayList::new));
    }

    @Override
    public String offline(String selectorName, List<URIRegisterDTO> uriList) {
        SelectorService selectorService = this.getSelectorService();
        SelectorDO selectorDO = selectorService.findByNameAndPluginName(selectorName, PluginNameAdapter.rpcTypeAdapter((String)this.rpcType()));
        if (Objects.isNull(selectorDO)) {
            return "success";
        }
        List<URIRegisterDTO> validUriList = uriList.stream().filter(dto -> Objects.nonNull(dto.getPort()) && StringUtils.isNotBlank((CharSequence)dto.getHost())).collect(Collectors.toList());
        List<DivideUpstream> needToRemove = this.buildDivideUpstreamList(validUriList);
        List existList = GsonUtils.getInstance().fromCurrentList(selectorDO.getHandle(), DivideUpstream.class);
        existList.removeAll(needToRemove);
        String handler = GsonUtils.getInstance().toJson((Object)existList);
        selectorDO.setHandle(handler);
        SelectorData selectorData = selectorService.buildByName(selectorName, PluginNameAdapter.rpcTypeAdapter((String)this.rpcType()));
        selectorData.setHandle(handler);
        selectorService.updateSelective(selectorDO);
        this.getEventPublisher().publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.SELECTOR, DataEventTypeEnum.UPDATE, Collections.singletonList(selectorData)));
        return "success";
    }
}

