/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.shenyu.admin.aspect.annotation.RestApi;
import org.apache.shenyu.admin.model.dto.FieldDTO;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.FieldQuery;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.service.FieldService;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@RestApi(value={"/field"})
public class FieldController {
    private final FieldService fieldService;

    public FieldController(FieldService fieldService) {
        this.fieldService = fieldService;
    }

    @PostMapping(value={"/insertOrUpdate"})
    public ShenyuAdminResult createOrUpdate(@Valid @RequestBody FieldDTO fieldDTO) {
        return ShenyuAdminResult.success("success", this.fieldService.createOrUpdate(fieldDTO));
    }

    @DeleteMapping(value={"/batchDelete"})
    public ShenyuAdminResult batchDelete(@RequestBody @NotEmpty List<@NotBlank String> ids) {
        Integer deleteCount = this.fieldService.deleteBatch(ids);
        return ShenyuAdminResult.success("delete success", deleteCount);
    }

    @GetMapping(value={"/findPageByQuery"})
    public ShenyuAdminResult listByPage(String name, String fieldDesc, @RequestParam @NotNull(message="currentPage not null") @NotNull(message="currentPage not null") Integer currentPage, @RequestParam @NotNull(message="pageSize not null") @NotNull(message="pageSize not null") Integer pageSize) {
        PageParameter pageParameter = new PageParameter(currentPage, pageSize);
        return ShenyuAdminResult.success("query success", this.fieldService.listByPage(new FieldQuery(name, fieldDesc, pageParameter)));
    }
}

