/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.shenyu.admin.aspect.annotation.RestApi;
import org.apache.shenyu.admin.mapper.MockRequestRecordMapper;
import org.apache.shenyu.admin.model.dto.MockRequestRecordDTO;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.MockRequestRecordQuery;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.service.MockRequestRecordService;
import org.apache.shenyu.admin.validation.annotation.Existed;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@RestApi(value={"/mock"})
public class MockRequestRecordController {
    private final MockRequestRecordService mockRequestRecordService;

    public MockRequestRecordController(MockRequestRecordService mockRequestRecordService) {
        this.mockRequestRecordService = mockRequestRecordService;
    }

    @PostMapping(value={"/insertOrUpdate"})
    public ShenyuAdminResult createOrUpdate(@Valid @RequestBody MockRequestRecordDTO mockRequestRecordDTO) {
        return ShenyuAdminResult.success("success", this.mockRequestRecordService.createOrUpdate(mockRequestRecordDTO));
    }

    @DeleteMapping(value={"/batchDelete"})
    public ShenyuAdminResult batchDelete(@RequestBody @NotEmpty List<@NotBlank String> ids) {
        Integer deleteCount = this.mockRequestRecordService.batchDelete(ids);
        return ShenyuAdminResult.success("delete success", deleteCount);
    }

    @DeleteMapping(value={"/{id}"})
    public ShenyuAdminResult delete(@PathVariable @Valid @Existed(provider=MockRequestRecordMapper.class, message=" is not existed") @Valid @Existed(provider=MockRequestRecordMapper.class, message=" is not existed") String id) {
        return ShenyuAdminResult.success("delete success", this.mockRequestRecordService.delete(id));
    }

    @GetMapping(value={"/findPageByQuery"})
    public ShenyuAdminResult listByPage(String apiId, String host, String url, String pathVariable, String header, @RequestParam @NotNull(message="currentPage not null") @NotNull(message="currentPage not null") Integer currentPage, @RequestParam @NotNull(message="pageSize not null") @NotNull(message="pageSize not null") Integer pageSize) {
        PageParameter pageParameter = new PageParameter(currentPage, pageSize);
        return ShenyuAdminResult.success("query success", this.mockRequestRecordService.listByPage(new MockRequestRecordQuery(apiId, host, url, pathVariable, header, pageParameter)));
    }

    @GetMapping(value={"/{apiId}"})
    public ShenyuAdminResult get(@PathVariable String apiId) {
        return ShenyuAdminResult.success("query success", this.mockRequestRecordService.queryByApiId(apiId));
    }
}

