/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.shenyu.admin.aspect.annotation.RestApi;
import org.apache.shenyu.admin.mapper.RoleMapper;
import org.apache.shenyu.admin.model.dto.RoleDTO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.RoleQuery;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.RoleEditVO;
import org.apache.shenyu.admin.model.vo.RoleVO;
import org.apache.shenyu.admin.service.RoleService;
import org.apache.shenyu.admin.validation.annotation.Existed;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@RestApi(value={"/role"})
public class RoleController {
    private static final String SUPER = "super";
    private final RoleService roleService;

    public RoleController(RoleService roleService) {
        this.roleService = roleService;
    }

    @GetMapping(value={"/getAllRoles"})
    @RequiresPermissions(value={"system:role:list"})
    public ShenyuAdminResult selectAll() {
        return ShenyuAdminResult.success("query success", this.roleService.selectAll());
    }

    @GetMapping(value={""})
    @RequiresPermissions(value={"system:role:list"})
    public ShenyuAdminResult queryRole(String roleName, @RequestParam @NotNull Integer currentPage, @RequestParam @NotNull Integer pageSize) {
        CommonPager<RoleVO> commonPager = this.roleService.listByPage(new RoleQuery(roleName, new PageParameter(currentPage, pageSize)));
        return ShenyuAdminResult.success("query success", commonPager);
    }

    @GetMapping(value={"/{id}"})
    @RequiresPermissions(value={"system:role:edit"})
    public ShenyuAdminResult detailRole(@PathVariable(value="id") @Valid @Existed(provider=RoleMapper.class, message="role is not existed") @Valid @Existed(provider=RoleMapper.class, message="role is not existed") String id) {
        RoleEditVO roleEditVO = this.roleService.findById(id);
        return Optional.ofNullable(roleEditVO).map(item -> ShenyuAdminResult.success("detail success", item)).orElse(ShenyuAdminResult.error("detail failed"));
    }

    @PostMapping(value={""})
    @RequiresPermissions(value={"system:role:add"})
    public ShenyuAdminResult createRole(@Valid @RequestBody RoleDTO roleDTO) {
        if (SUPER.equals(roleDTO.getRoleName())) {
            return ShenyuAdminResult.error("can not create super role");
        }
        return ShenyuAdminResult.success("create success", this.roleService.createOrUpdate(roleDTO));
    }

    @PutMapping(value={"/{id}"})
    @RequiresPermissions(value={"system:role:edit"})
    public ShenyuAdminResult updateRole(@PathVariable(value="id") @Valid @Existed(provider=RoleMapper.class, message="role is not existed") @Valid @Existed(provider=RoleMapper.class, message="role is not existed") String id, @Valid @RequestBody RoleDTO roleDTO) {
        roleDTO.setId(id);
        return ShenyuAdminResult.success("update success", this.roleService.createOrUpdate(roleDTO));
    }

    @DeleteMapping(value={"/batch"})
    @RequiresPermissions(value={"system:role:delete"})
    public ShenyuAdminResult deleteRole(@RequestBody @NotEmpty List<@NotBlank String> ids) {
        return ShenyuAdminResult.success("delete success", this.roleService.delete(ids));
    }
}

