/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.apache.shenyu.admin.aspect.annotation.RestApi;
import org.apache.shenyu.admin.model.dto.TagRelationDTO;
import org.apache.shenyu.admin.model.entity.TagRelationDO;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.service.TagRelationService;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

@RestApi(value={"/tag-relation/"})
public class TagRelationController {
    private final TagRelationService tagRelationService;

    public TagRelationController(TagRelationService tagRelationService) {
        this.tagRelationService = tagRelationService;
    }

    @GetMapping(value={"/tagId/{tagId}"})
    public ShenyuAdminResult queryApiByTagId(@PathVariable(value="tagId") @Valid String tagId) {
        List<TagRelationDO> tagRelationDOS = Optional.ofNullable(this.tagRelationService.findByTagId(tagId)).orElse(Lists.newArrayList());
        return ShenyuAdminResult.success("detail success", tagRelationDOS);
    }

    @PutMapping(value={"/id/{id}"})
    public ShenyuAdminResult updateTagRelation(@PathVariable(value="id") @Valid String id, @Valid @RequestBody TagRelationDTO tagRelationDTO) {
        tagRelationDTO.setId(id);
        Integer updateCount = this.tagRelationService.update(tagRelationDTO);
        return ShenyuAdminResult.success("update success", updateCount);
    }

    @DeleteMapping(value={"/batchDelete"})
    public ShenyuAdminResult deleteTagRelation(@RequestBody @NotEmpty List<@NotBlank String> ids) {
        Integer deleteCount = this.tagRelationService.delete(ids);
        return ShenyuAdminResult.success("delete success", deleteCount);
    }
}

