/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.disruptor.executor;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.disruptor.consumer.QueueConsumerExecutor;
import org.apache.shenyu.disruptor.consumer.QueueConsumerFactory;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.subsriber.ExecutorSubscriber;
import org.apache.shenyu.register.common.subsriber.ExecutorTypeSubscriber;
import org.apache.shenyu.register.common.type.DataType;
import org.apache.shenyu.register.common.type.DataTypeParent;

public final class RegisterServerConsumerExecutor
extends QueueConsumerExecutor<Collection<DataTypeParent>> {
    private final Map<DataType, ExecutorSubscriber<DataTypeParent>> subscribers;

    private RegisterServerConsumerExecutor(Map<DataType, ExecutorTypeSubscriber<DataTypeParent>> executorSubscriberMap) {
        this.subscribers = new HashMap<DataType, ExecutorTypeSubscriber<DataTypeParent>>(executorSubscriberMap);
    }

    public void run() {
        Collection results = ((Collection)this.getData()).stream().filter(this::isValidData).collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)results)) {
            return;
        }
        this.selectExecutor(results).executor(results);
    }

    private boolean isValidData(Object data) {
        if (data instanceof URIRegisterDTO) {
            URIRegisterDTO uriRegisterDTO = (URIRegisterDTO)data;
            return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{uriRegisterDTO.getContextPath(), uriRegisterDTO.getRpcType()});
        }
        if (data instanceof MetaDataRegisterDTO) {
            MetaDataRegisterDTO metaDataRegisterDTO = (MetaDataRegisterDTO)data;
            return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{metaDataRegisterDTO.getAppName(), metaDataRegisterDTO.getPath(), metaDataRegisterDTO.getRuleName(), metaDataRegisterDTO.getRpcType()});
        }
        return true;
    }

    private ExecutorSubscriber<DataTypeParent> selectExecutor(Collection<DataTypeParent> list) {
        Optional<DataTypeParent> first = list.stream().findFirst();
        return this.subscribers.get(first.orElseThrow(() -> new RuntimeException("the data type is not found")).getType());
    }

    public static class RegisterServerExecutorFactory
    implements QueueConsumerFactory<Collection<DataTypeParent>> {
        private final Set<ExecutorTypeSubscriber<? extends DataTypeParent>> subscribers = new HashSet<ExecutorTypeSubscriber<? extends DataTypeParent>>();

        public QueueConsumerExecutor<Collection<DataTypeParent>> create() {
            Map maps = this.getSubscribers().stream().map(e -> e).collect(Collectors.toMap(ExecutorTypeSubscriber::getType, Function.identity()));
            return new RegisterServerConsumerExecutor(maps);
        }

        public String fixName() {
            return "shenyu_register_server";
        }

        public RegisterServerExecutorFactory addSubscribers(ExecutorTypeSubscriber<? extends DataTypeParent> subscriber) {
            this.subscribers.add(subscriber);
            return this;
        }

        public Set<ExecutorTypeSubscriber<? extends DataTypeParent>> getSubscribers() {
            return this.subscribers;
        }
    }
}

