/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.disruptor.subscriber;

import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.shenyu.admin.service.DiscoveryService;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.register.common.dto.DiscoveryConfigRegisterDTO;
import org.apache.shenyu.register.common.subsriber.ExecutorTypeSubscriber;
import org.apache.shenyu.register.common.type.DataType;

public class DiscoveryConfigRegisterExecutorSubscriber
implements ExecutorTypeSubscriber<DiscoveryConfigRegisterDTO> {
    private final DiscoveryService discoveryService;
    private final ScheduledExecutorService executorService;

    public DiscoveryConfigRegisterExecutorSubscriber(DiscoveryService discoveryService) {
        this.discoveryService = discoveryService;
        this.executorService = new ScheduledThreadPoolExecutor(10, ShenyuThreadFactory.create((String)"scheduled-eureka-watcher", (boolean)true));
    }

    public void executor(Collection<DiscoveryConfigRegisterDTO> discoveryConfigRegisterDTOS) {
        this.executorService.schedule(() -> discoveryConfigRegisterDTOS.forEach(this.discoveryService::registerDiscoveryConfig), 2L, TimeUnit.SECONDS);
    }

    public DataType getType() {
        return DataType.DISCOVERY_CONFIG;
    }
}

