/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.vo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.shenyu.admin.model.vo.ResourceVO;
import org.apache.shenyu.admin.model.vo.RoleVO;

public class RoleEditVO
implements Serializable {
    private static final long serialVersionUID = -292613858092450065L;
    private List<String> rolePermissionList;
    private RoleVO sysRole;
    private PermissionInfo allPermissionInfo;

    public RoleEditVO() {
    }

    public RoleEditVO(List<String> rolePermissionList, RoleVO sysRole, PermissionInfo allPermissionInfo) {
        this.rolePermissionList = rolePermissionList;
        this.sysRole = sysRole;
        this.allPermissionInfo = allPermissionInfo;
    }

    public List<String> getRolePermissionList() {
        return this.rolePermissionList;
    }

    public void setRolePermissionList(List<String> rolePermissionList) {
        this.rolePermissionList = rolePermissionList;
    }

    public RoleVO getSysRole() {
        return this.sysRole;
    }

    public void setSysRole(RoleVO sysRole) {
        this.sysRole = sysRole;
    }

    public PermissionInfo getAllPermissionInfo() {
        return this.allPermissionInfo;
    }

    public void setAllPermissionInfo(PermissionInfo allPermissionInfo) {
        this.allPermissionInfo = allPermissionInfo;
    }

    public static class ResourceInfo {
        private String id;
        private String title;
        private String name;
        private List<ResourceInfo> children;
        private Boolean isLeaf;
        private String parentId;

        public ResourceInfo() {
        }

        public ResourceInfo(String id, String title, String name, List<ResourceInfo> children, Boolean isLeaf, String parentId) {
            this.id = id;
            this.title = title;
            this.name = name;
            this.children = children;
            this.isLeaf = isLeaf;
            this.parentId = parentId;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<ResourceInfo> getChildren() {
            return this.children;
        }

        public void setChildren(List<ResourceInfo> children) {
            this.children = children;
        }

        public Boolean getIsLeaf() {
            return this.isLeaf;
        }

        public void setIsLeaf(Boolean isLeaf) {
            this.isLeaf = isLeaf;
        }

        public String getParentId() {
            return this.parentId;
        }

        public void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public static ResourceInfo buildResourceInfo(ResourceVO resourceVO) {
            return Optional.ofNullable(resourceVO).map(item -> {
                ResourceInfo resourceInfo = ResourceInfo.builder().id(item.getId()).title(item.getTitle()).name(item.getName()).parentId(item.getParentId()).isLeaf(item.getIsLeaf()).build();
                if (item.getIsLeaf().equals(Boolean.FALSE)) {
                    resourceInfo.setChildren(new ArrayList<ResourceInfo>());
                }
                return resourceInfo;
            }).orElse(null);
        }

        public static ResourceInfoBuilder builder() {
            return new ResourceInfoBuilder();
        }

        public static final class ResourceInfoBuilder {
            private String id;
            private String title;
            private String name;
            private List<ResourceInfo> children;
            private Boolean isLeaf;
            private String parentId;

            public ResourceInfoBuilder() {
            }

            public ResourceInfoBuilder(String id, String title, String name, List<ResourceInfo> children, Boolean isLeaf, String parentId) {
                this.id = id;
                this.title = title;
                this.name = name;
                this.children = children;
                this.isLeaf = isLeaf;
                this.parentId = parentId;
            }

            public ResourceInfoBuilder id(String id) {
                this.id = id;
                return this;
            }

            public ResourceInfoBuilder title(String title) {
                this.title = title;
                return this;
            }

            public ResourceInfoBuilder name(String name) {
                this.name = name;
                return this;
            }

            public ResourceInfoBuilder children(List<ResourceInfo> children) {
                this.children = children;
                return this;
            }

            public ResourceInfoBuilder isLeaf(Boolean isLeaf) {
                this.isLeaf = isLeaf;
                return this;
            }

            public ResourceInfoBuilder parentId(String parentId) {
                this.parentId = parentId;
                return this;
            }

            public ResourceInfo build() {
                return new ResourceInfo(this.id, this.title, this.name, this.children, this.isLeaf, this.parentId);
            }
        }
    }

    public static class PermissionInfo {
        private List<ResourceInfo> treeList;
        private List<String> permissionIds;

        public PermissionInfo() {
        }

        public PermissionInfo(List<ResourceInfo> treeList, List<String> permissionIds) {
            this.treeList = treeList;
            this.permissionIds = permissionIds;
        }

        public List<ResourceInfo> getTreeList() {
            return this.treeList;
        }

        public void setTreeList(List<ResourceInfo> treeList) {
            this.treeList = treeList;
        }

        public List<String> getPermissionIds() {
            return this.permissionIds;
        }

        public void setPermissionIds(List<String> permissionIds) {
            this.permissionIds = permissionIds;
        }

        public static PermissionInfoBuilder builder() {
            return new PermissionInfoBuilder();
        }

        public static final class PermissionInfoBuilder {
            private List<ResourceInfo> treeList;
            private List<String> permissionIds;

            public PermissionInfoBuilder treeList(List<ResourceInfo> treeList) {
                this.treeList = treeList;
                return this;
            }

            public PermissionInfoBuilder permissionIds(List<String> permissionIds) {
                this.permissionIds = permissionIds;
                return this;
            }

            public PermissionInfo build() {
                return new PermissionInfo(this.treeList, this.permissionIds);
            }
        }
    }
}

