/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.exception.ShenyuAdminException;
import org.apache.shenyu.admin.model.dto.RuleConditionDTO;
import org.apache.shenyu.admin.model.dto.RuleDTO;
import org.apache.shenyu.admin.model.entity.RuleDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.query.RuleQuery;
import org.apache.shenyu.admin.model.query.RuleQueryCondition;
import org.apache.shenyu.admin.model.vo.RuleVO;
import org.apache.shenyu.admin.service.PageService;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.enums.OperatorEnum;
import org.apache.shenyu.common.enums.ParamTypeEnum;
import org.springframework.web.util.pattern.PathPatternParser;

public interface RuleService
extends PageService<RuleQueryCondition, RuleVO> {
    public String registerDefault(RuleDTO var1);

    default public int createOrUpdate(RuleDTO ruleDTO) {
        try {
            List<RuleConditionDTO> ruleConditions = ruleDTO.getRuleConditions();
            ruleConditions.stream().filter(conditionData -> ParamTypeEnum.URI.getName().equals(conditionData.getParamType())).filter(conditionData -> OperatorEnum.PATH_PATTERN.getAlias().equals(conditionData.getOperator())).map(RuleConditionDTO::getParamValue).forEach(arg_0 -> ((PathPatternParser)PathPatternParser.defaultInstance).parse(arg_0));
        }
        catch (Exception e) {
            throw new ShenyuAdminException("uri validation of Condition failed, please check.", e);
        }
        return StringUtils.isBlank((CharSequence)ruleDTO.getId()) ? this.create(ruleDTO) : this.update(ruleDTO);
    }

    public int create(RuleDTO var1);

    public int update(RuleDTO var1);

    public int delete(List<String> var1);

    public RuleVO findById(String var1);

    public CommonPager<RuleVO> listByPage(RuleQuery var1);

    public List<RuleData> listAll();

    public List<RuleData> findBySelectorId(String var1);

    public List<RuleData> findBySelectorIdList(List<String> var1);

    public RuleDO findByName(String var1);

    public RuleDO findBySelectorIdAndName(String var1, String var2);
}

