/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shenyu.admin.aspect.annotation.Pageable;
import org.apache.shenyu.admin.mapper.AlertReceiverMapper;
import org.apache.shenyu.admin.model.entity.AlertReceiverDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.AlertReceiverQuery;
import org.apache.shenyu.admin.service.AlertDispatchService;
import org.apache.shenyu.admin.service.AlertReceiverService;
import org.apache.shenyu.alert.model.AlertReceiverDTO;
import org.apache.shenyu.common.dto.AlarmContent;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlertReceiverServiceImpl
implements AlertReceiverService {
    private static final String ALERT_TEST_TITLE = "Alarm Test";
    private static final String ALERT_TEST_CONTENT = "test send msg! \n This is the test data. It is proved that it can be received successfully";
    @Autowired
    private AlertReceiverMapper alertReceiverMapper;
    @Autowired
    private AlertDispatchService alertDispatchService;

    @Override
    public void addReceiver(AlertReceiverDTO alertReceiverDTO) {
        AlertReceiverDO receiverDO = new AlertReceiverDO();
        BeanUtils.copyProperties((Object)alertReceiverDTO, (Object)receiverDO);
        receiverDO.setId(UUIDUtils.getInstance().generateShortUuid());
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        receiverDO.setDateCreated(currentTime);
        receiverDO.setDateUpdated(currentTime);
        this.alertDispatchService.clearCache();
        this.alertReceiverMapper.insert(receiverDO);
    }

    @Override
    public void deleteReceiver(List<String> ids) {
        this.alertDispatchService.clearCache();
        this.alertReceiverMapper.deleteByIds(ids);
    }

    @Override
    public void updateReceiver(AlertReceiverDTO alertReceiverDTO) {
        AlertReceiverDO receiverDO = new AlertReceiverDO();
        BeanUtils.copyProperties((Object)alertReceiverDTO, (Object)receiverDO);
        this.alertDispatchService.clearCache();
        this.alertReceiverMapper.updateByPrimaryKey(receiverDO);
    }

    @Override
    public List<AlertReceiverDTO> getAll() {
        return this.alertReceiverMapper.selectAll();
    }

    @Override
    @Pageable
    public CommonPager<AlertReceiverDTO> listByPage(AlertReceiverQuery receiverQuery) {
        return PageResultUtils.result(receiverQuery.getPageParameter(), () -> this.alertReceiverMapper.selectByQuery(receiverQuery).stream().map(item -> {
            AlertReceiverDTO receiverDTO = new AlertReceiverDTO();
            BeanUtils.copyProperties((Object)item, (Object)receiverDTO);
            return receiverDTO;
        }).collect(Collectors.toList()));
    }

    @Override
    public AlertReceiverDTO detail(String id) {
        AlertReceiverDTO receiverDTO = new AlertReceiverDTO();
        AlertReceiverDO receiverDO = this.alertReceiverMapper.selectByPrimaryKey(id);
        if (receiverDO != null) {
            BeanUtils.copyProperties((Object)receiverDO, (Object)receiverDTO);
            return receiverDTO;
        }
        return null;
    }

    @Override
    public boolean sendTestMsg(AlertReceiverDTO alertReceiverDTO) {
        AlarmContent content = new AlarmContent.Builder().title(ALERT_TEST_TITLE).content(ALERT_TEST_CONTENT).level((byte)2).dateCreated(new Date()).dateUpdated(new Date()).build();
        return this.alertDispatchService.sendNoticeMsg(alertReceiverDTO, content);
    }
}

