/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shenyu.admin.aspect.annotation.Pageable;
import org.apache.shenyu.admin.discovery.DiscoveryLevel;
import org.apache.shenyu.admin.discovery.DiscoveryProcessor;
import org.apache.shenyu.admin.discovery.DiscoveryProcessorHolder;
import org.apache.shenyu.admin.mapper.DiscoveryHandlerMapper;
import org.apache.shenyu.admin.mapper.DiscoveryMapper;
import org.apache.shenyu.admin.mapper.DiscoveryRelMapper;
import org.apache.shenyu.admin.mapper.DiscoveryUpstreamMapper;
import org.apache.shenyu.admin.mapper.ProxySelectorMapper;
import org.apache.shenyu.admin.mapper.SelectorMapper;
import org.apache.shenyu.admin.model.dto.DiscoveryDTO;
import org.apache.shenyu.admin.model.dto.DiscoveryHandlerDTO;
import org.apache.shenyu.admin.model.dto.DiscoveryUpstreamDTO;
import org.apache.shenyu.admin.model.dto.ProxySelectorAddDTO;
import org.apache.shenyu.admin.model.dto.ProxySelectorDTO;
import org.apache.shenyu.admin.model.entity.DiscoveryDO;
import org.apache.shenyu.admin.model.entity.DiscoveryHandlerDO;
import org.apache.shenyu.admin.model.entity.DiscoveryRelDO;
import org.apache.shenyu.admin.model.entity.DiscoveryUpstreamDO;
import org.apache.shenyu.admin.model.entity.ProxySelectorDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.ProxySelectorQuery;
import org.apache.shenyu.admin.model.vo.DiscoveryUpstreamVO;
import org.apache.shenyu.admin.model.vo.ProxySelectorVO;
import org.apache.shenyu.admin.service.ProxySelectorService;
import org.apache.shenyu.admin.transfer.DiscoveryTransfer;
import org.apache.shenyu.common.dto.ProxySelectorData;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ProxySelectorServiceImpl
implements ProxySelectorService {
    private static final Logger LOG = LoggerFactory.getLogger(ProxySelectorServiceImpl.class);
    private final ProxySelectorMapper proxySelectorMapper;
    private final DiscoveryMapper discoveryMapper;
    private final DiscoveryRelMapper discoveryRelMapper;
    private final DiscoveryUpstreamMapper discoveryUpstreamMapper;
    private final DiscoveryHandlerMapper discoveryHandlerMapper;
    private final SelectorMapper selectorMapper;
    private final DiscoveryProcessorHolder discoveryProcessorHolder;

    public ProxySelectorServiceImpl(ProxySelectorMapper proxySelectorMapper, DiscoveryMapper discoveryMapper, DiscoveryUpstreamMapper discoveryUpstreamMapper, DiscoveryHandlerMapper discoveryHandlerMapper, DiscoveryRelMapper discoveryRelMapper, SelectorMapper selectorMapper, DiscoveryProcessorHolder discoveryProcessorHolder) {
        this.proxySelectorMapper = proxySelectorMapper;
        this.discoveryMapper = discoveryMapper;
        this.discoveryRelMapper = discoveryRelMapper;
        this.discoveryUpstreamMapper = discoveryUpstreamMapper;
        this.discoveryHandlerMapper = discoveryHandlerMapper;
        this.selectorMapper = selectorMapper;
        this.discoveryProcessorHolder = discoveryProcessorHolder;
    }

    @Override
    @Pageable
    public CommonPager<ProxySelectorVO> listByPage(ProxySelectorQuery query) {
        ArrayList result = Lists.newArrayList();
        List<ProxySelectorDO> proxySelectorDOList = this.proxySelectorMapper.selectByQuery(query);
        proxySelectorDOList.forEach(proxySelectorDO -> {
            DiscoveryHandlerDO discoveryHandlerDO;
            ProxySelectorVO vo = new ProxySelectorVO();
            vo.setId(proxySelectorDO.getId());
            vo.setName(proxySelectorDO.getName());
            vo.setType(proxySelectorDO.getType());
            vo.setForwardPort(proxySelectorDO.getForwardPort());
            vo.setCreateTime(proxySelectorDO.getDateCreated());
            vo.setUpdateTime(proxySelectorDO.getDateUpdated());
            vo.setProps(proxySelectorDO.getProps());
            DiscoveryRelDO discoveryRelDO = this.discoveryRelMapper.selectByProxySelectorId(proxySelectorDO.getId());
            if (!Objects.isNull(discoveryRelDO) && !Objects.isNull(discoveryHandlerDO = this.discoveryHandlerMapper.selectById(discoveryRelDO.getDiscoveryHandlerId()))) {
                vo.setDiscoveryHandlerId(discoveryHandlerDO.getId());
                vo.setListenerNode(discoveryHandlerDO.getListenerNode());
                vo.setHandler(discoveryHandlerDO.getHandler());
                DiscoveryDO discoveryDO = this.discoveryMapper.selectById(discoveryHandlerDO.getDiscoveryId());
                DiscoveryDTO discoveryDTO = new DiscoveryDTO();
                BeanUtils.copyProperties((Object)discoveryDO, (Object)discoveryDTO);
                vo.setDiscovery(discoveryDTO);
                List<DiscoveryUpstreamDO> discoveryUpstreamDOList = this.discoveryUpstreamMapper.selectByDiscoveryHandlerId(discoveryRelDO.getDiscoveryHandlerId());
                Optional.ofNullable(discoveryUpstreamDOList).ifPresent(list -> {
                    List<DiscoveryUpstreamVO> upstreamVOS = list.stream().map(DiscoveryTransfer.INSTANCE::mapToVo).collect(Collectors.toList());
                    vo.setDiscoveryUpstreams(upstreamVOS);
                });
            }
            result.add(vo);
        });
        return PageResultUtils.result(query.getPageParameter(), () -> result);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String createOrUpdate(ProxySelectorAddDTO proxySelectorAddDTO) {
        if (StringUtils.hasLength((String)proxySelectorAddDTO.getId())) {
            return this.update(proxySelectorAddDTO);
        }
        return this.create(proxySelectorAddDTO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String delete(List<String> ids) {
        for (String proxySelectorId : ids) {
            DiscoveryHandlerDO discoveryHandlerDO = this.discoveryHandlerMapper.selectByProxySelectorId(proxySelectorId);
            if (!Objects.nonNull(discoveryHandlerDO)) continue;
            ProxySelectorDO proxySelectorDO = this.proxySelectorMapper.selectById(proxySelectorId);
            DiscoveryDO discoveryDO = this.discoveryMapper.selectById(discoveryHandlerDO.getDiscoveryId());
            DiscoveryProcessor discoveryProcessor = this.discoveryProcessorHolder.chooseProcessor(discoveryDO.getType());
            discoveryProcessor.removeProxySelector(DiscoveryTransfer.INSTANCE.mapToDTO(discoveryHandlerDO), DiscoveryTransfer.INSTANCE.mapToDTO(proxySelectorDO));
            if (DiscoveryLevel.SELECTOR.getCode().equals(discoveryDO.getLevel())) {
                discoveryProcessor.removeDiscovery(discoveryDO);
                this.discoveryMapper.delete(discoveryDO.getId());
            }
            this.discoveryUpstreamMapper.deleteByDiscoveryHandlerId(discoveryHandlerDO.getId());
            this.discoveryHandlerMapper.delete(discoveryHandlerDO.getId());
            this.discoveryRelMapper.deleteByDiscoveryHandlerId(discoveryHandlerDO.getId());
        }
        this.proxySelectorMapper.deleteByIds(ids);
        return "delete success";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String create(ProxySelectorAddDTO proxySelectorAddDTO) {
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        ProxySelectorDO proxySelectorDO = ProxySelectorDO.buildProxySelectorDO(proxySelectorAddDTO);
        String proxySelectorId = proxySelectorDO.getId();
        if (this.proxySelectorMapper.insert(proxySelectorDO) > 0) {
            boolean fillDiscovery;
            String discoveryId;
            DiscoveryProcessor discoveryProcessor = this.discoveryProcessorHolder.chooseProcessor(proxySelectorAddDTO.getDiscovery().getDiscoveryType());
            if (StringUtils.hasLength((String)proxySelectorAddDTO.getDiscovery().getId())) {
                DiscoveryDO discoveryDO = this.discoveryMapper.selectById(proxySelectorAddDTO.getDiscovery().getId());
                discoveryId = proxySelectorAddDTO.getDiscovery().getId();
                fillDiscovery = Objects.nonNull(discoveryDO);
            } else {
                discoveryId = UUIDUtils.getInstance().generateShortUuid();
                DiscoveryDO discoveryDO = ProxySelectorServiceImpl.buildDiscovery(proxySelectorAddDTO, currentTime, discoveryId);
                fillDiscovery = this.discoveryMapper.insertSelective(discoveryDO) > 0;
                discoveryProcessor.createDiscovery(discoveryDO);
            }
            if (fillDiscovery) {
                String discoveryHandlerId = UUIDUtils.getInstance().generateShortUuid();
                DiscoveryHandlerDO discoveryHandlerDO = DiscoveryHandlerDO.builder().id(discoveryHandlerId).discoveryId(discoveryId).dateCreated(currentTime).dateUpdated(currentTime).listenerNode(proxySelectorAddDTO.getListenerNode()).handler(proxySelectorAddDTO.getHandler() == null ? "" : proxySelectorAddDTO.getHandler()).props(proxySelectorAddDTO.getProps()).build();
                this.discoveryHandlerMapper.insertSelective(discoveryHandlerDO);
                DiscoveryRelDO discoveryRelDO = DiscoveryRelDO.builder().id(UUIDUtils.getInstance().generateShortUuid()).pluginName(proxySelectorAddDTO.getPluginName()).discoveryHandlerId(discoveryHandlerId).proxySelectorId(proxySelectorId).selectorId("").dateCreated(currentTime).dateUpdated(currentTime).build();
                this.discoveryRelMapper.insertSelective(discoveryRelDO);
                DiscoveryHandlerDTO discoveryHandlerDTO = DiscoveryTransfer.INSTANCE.mapToDTO(discoveryHandlerDO);
                ProxySelectorDTO proxySelectorDTO = DiscoveryTransfer.INSTANCE.mapToDTO(proxySelectorDO);
                proxySelectorDTO.setId(proxySelectorId);
                discoveryProcessor.createProxySelector(discoveryHandlerDTO, proxySelectorDTO);
                this.addUpstreamList(proxySelectorAddDTO, currentTime, discoveryProcessor, discoveryHandlerId, proxySelectorDTO);
            }
        }
        return "create success";
    }

    private void addUpstreamList(ProxySelectorAddDTO proxySelectorAddDTO, Timestamp currentTime, DiscoveryProcessor discoveryProcessor, String discoveryHandlerId, ProxySelectorDTO proxySelectorDTO) {
        ArrayList upstreamDOList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(proxySelectorAddDTO.getDiscoveryUpstreams())) {
            proxySelectorAddDTO.getDiscoveryUpstreams().forEach(discoveryUpstream -> {
                DiscoveryUpstreamDO discoveryUpstreamDO = DiscoveryUpstreamDO.builder().id(UUIDUtils.getInstance().generateShortUuid()).discoveryHandlerId(discoveryHandlerId).protocol(discoveryUpstream.getProtocol()).url(discoveryUpstream.getUrl()).status(discoveryUpstream.getStatus()).weight(discoveryUpstream.getWeight()).props(Optional.ofNullable(discoveryUpstream.getProps()).orElse("{}")).dateCreated(currentTime).dateUpdated(currentTime).build();
                upstreamDOList.add(discoveryUpstreamDO);
            });
            this.discoveryUpstreamMapper.saveBatch(upstreamDOList);
            List<DiscoveryUpstreamDTO> collect = upstreamDOList.stream().map(DiscoveryTransfer.INSTANCE::mapToDTO).collect(Collectors.toList());
            discoveryProcessor.changeUpstream(proxySelectorDTO, collect);
        }
    }

    @NotNull
    private static DiscoveryDO buildDiscovery(ProxySelectorAddDTO proxySelectorAddDTO, Timestamp currentTime, String discoveryId) {
        return DiscoveryDO.builder().id(discoveryId).name(proxySelectorAddDTO.getName()).type(proxySelectorAddDTO.getDiscovery().getDiscoveryType()).serverList(proxySelectorAddDTO.getDiscovery().getServerList()).pluginName(proxySelectorAddDTO.getPluginName()).level(DiscoveryLevel.SELECTOR.getCode()).dateCreated(currentTime).dateUpdated(currentTime).props(proxySelectorAddDTO.getDiscovery().getProps()).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String bindingDiscoveryHandler(ProxySelectorAddDTO proxySelectorAddDTO) {
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        String selectorId = proxySelectorAddDTO.getSelectorId();
        DiscoveryProcessor discoveryProcessor = this.discoveryProcessorHolder.chooseProcessor(proxySelectorAddDTO.getDiscovery().getDiscoveryType());
        ProxySelectorAddDTO.Discovery discovery = proxySelectorAddDTO.getDiscovery();
        String discoveryId = discovery.getId();
        if (!StringUtils.hasLength((String)discoveryId)) {
            discoveryId = UUIDUtils.getInstance().generateShortUuid();
            DiscoveryDO discoveryDO = ProxySelectorServiceImpl.buildDiscovery(proxySelectorAddDTO, currentTime, discoveryId);
            this.discoveryMapper.insertSelective(discoveryDO);
            discoveryProcessor.createDiscovery(discoveryDO);
        }
        String discoveryHandlerId = UUIDUtils.getInstance().generateShortUuid();
        DiscoveryHandlerDO discoveryHandlerDO = DiscoveryHandlerDO.builder().id(discoveryHandlerId).discoveryId(discoveryId).dateCreated(currentTime).dateUpdated(currentTime).listenerNode(proxySelectorAddDTO.getListenerNode()).handler(proxySelectorAddDTO.getHandler() == null ? "" : proxySelectorAddDTO.getHandler()).props(proxySelectorAddDTO.getProps()).build();
        this.discoveryHandlerMapper.insertSelective(discoveryHandlerDO);
        DiscoveryRelDO discoveryRelDO = DiscoveryRelDO.builder().id(UUIDUtils.getInstance().generateShortUuid()).pluginName(proxySelectorAddDTO.getPluginName()).discoveryHandlerId(discoveryHandlerId).selectorId(selectorId).dateCreated(currentTime).dateUpdated(currentTime).build();
        this.discoveryRelMapper.insertSelective(discoveryRelDO);
        ProxySelectorDTO proxySelectorDTO = new ProxySelectorDTO();
        proxySelectorDTO.setPluginName(proxySelectorAddDTO.getPluginName());
        proxySelectorDTO.setName(proxySelectorAddDTO.getName());
        proxySelectorDTO.setId(selectorId);
        DiscoveryHandlerDTO discoveryHandlerDTO = DiscoveryTransfer.INSTANCE.mapToDTO(discoveryHandlerDO);
        discoveryProcessor.createProxySelector(discoveryHandlerDTO, proxySelectorDTO);
        this.addUpstreamList(proxySelectorAddDTO, currentTime, discoveryProcessor, discoveryHandlerId, proxySelectorDTO);
        return "create success";
    }

    @Transactional(rollbackFor={Exception.class})
    public String update(ProxySelectorAddDTO proxySelectorAddDTO) {
        ProxySelectorDO proxySelectorDO = ProxySelectorDO.buildProxySelectorDO(proxySelectorAddDTO);
        this.proxySelectorMapper.update(proxySelectorDO);
        DiscoveryRelDO discoveryRelDO = this.discoveryRelMapper.selectByProxySelectorId(proxySelectorDO.getId());
        String discoveryHandlerId = discoveryRelDO.getDiscoveryHandlerId();
        DiscoveryHandlerDO discoveryHandlerDO = this.discoveryHandlerMapper.selectById(discoveryHandlerId);
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        discoveryHandlerDO.setHandler(proxySelectorAddDTO.getHandler());
        discoveryHandlerDO.setListenerNode(proxySelectorAddDTO.getListenerNode());
        discoveryHandlerDO.setProps(proxySelectorAddDTO.getProps());
        discoveryHandlerDO.setDateUpdated(currentTime);
        this.discoveryHandlerMapper.updateSelective(discoveryHandlerDO);
        DiscoveryDO discoveryDO = this.discoveryMapper.selectById(discoveryHandlerDO.getDiscoveryId());
        ProxySelectorAddDTO.Discovery discovery = proxySelectorAddDTO.getDiscovery();
        discoveryDO.setServerList(discovery.getServerList());
        discoveryDO.setDateUpdated(currentTime);
        discoveryDO.setProps(discovery.getProps());
        this.discoveryMapper.updateSelective(discoveryDO);
        int result = this.discoveryUpstreamMapper.deleteByDiscoveryHandlerId(discoveryHandlerId);
        LOG.info("delete discovery upstreams, count is: {}", (Object)result);
        proxySelectorAddDTO.getDiscoveryUpstreams().forEach(discoveryUpstream -> {
            DiscoveryUpstreamDO discoveryUpstreamDO = DiscoveryUpstreamDO.builder().id(UUIDUtils.getInstance().generateShortUuid()).discoveryHandlerId(discoveryHandlerId).protocol(discoveryUpstream.getProtocol()).url(discoveryUpstream.getUrl()).status(discoveryUpstream.getStatus()).weight(discoveryUpstream.getWeight()).props(discoveryUpstream.getProps()).dateCreated(Optional.ofNullable(discoveryUpstream.getStartupTime()).map(t -> new Timestamp(Long.parseLong(t))).orElse(currentTime)).dateUpdated(Optional.ofNullable(discoveryUpstream.getStartupTime()).map(t -> new Timestamp(Long.parseLong(t))).orElse(currentTime)).build();
            this.discoveryUpstreamMapper.insert(discoveryUpstreamDO);
        });
        List<DiscoveryUpstreamDTO> fetchAll = this.discoveryUpstreamMapper.selectByDiscoveryHandlerId(discoveryHandlerDO.getId()).stream().map(DiscoveryTransfer.INSTANCE::mapToDTO).collect(Collectors.toList());
        DiscoveryProcessor discoveryProcessor = this.discoveryProcessorHolder.chooseProcessor(discoveryDO.getType());
        discoveryProcessor.changeUpstream(DiscoveryTransfer.INSTANCE.mapToDTO(proxySelectorDO), fetchAll);
        LOG.info("insert discovery upstreams, count is: {}", (Object)proxySelectorAddDTO.getDiscoveryUpstreams().size());
        return "update success";
    }

    @Override
    public void fetchData(String discoveryHandlerId) {
        SelectorDO selectorDO;
        DiscoveryHandlerDO discoveryHandlerDO = this.discoveryHandlerMapper.selectById(discoveryHandlerId);
        DiscoveryDO discoveryDO = this.discoveryMapper.selectById(discoveryHandlerDO.getDiscoveryId());
        ProxySelectorDO proxySelectorDO = this.proxySelectorMapper.selectByHandlerId(discoveryHandlerId);
        DiscoveryHandlerDTO discoveryHandlerDTO = DiscoveryTransfer.INSTANCE.mapToDTO(discoveryHandlerDO);
        if (Objects.nonNull(proxySelectorDO)) {
            this.discoveryProcessorHolder.chooseProcessor(discoveryDO.getType()).fetchAll(discoveryHandlerDTO, DiscoveryTransfer.INSTANCE.mapToDTO(proxySelectorDO));
        }
        if (Objects.nonNull(selectorDO = this.selectorMapper.selectByDiscoveryHandlerId(discoveryHandlerId))) {
            ProxySelectorDTO proxySelectorDTO = new ProxySelectorDTO();
            proxySelectorDTO.setPluginName(discoveryDO.getPluginName());
            proxySelectorDTO.setName(selectorDO.getName());
            proxySelectorDTO.setId(selectorDO.getId());
            this.discoveryProcessorHolder.chooseProcessor(discoveryDO.getType()).fetchAll(discoveryHandlerDTO, proxySelectorDTO);
        }
    }

    @Override
    public List<ProxySelectorData> listAll() {
        return this.proxySelectorMapper.selectAll().stream().map(DiscoveryTransfer.INSTANCE::mapToData).collect(Collectors.toList());
    }
}

