/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.register;

import java.util.Objects;
import javax.annotation.Resource;
import org.apache.shenyu.admin.lock.RegisterExecutionLock;
import org.apache.shenyu.admin.lock.RegisterExecutionRepository;
import org.apache.shenyu.admin.service.register.AbstractShenyuClientRegisterServiceImpl;
import org.apache.shenyu.common.dto.convert.rule.impl.ContextMappingRuleHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.PathUtils;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;

public abstract class AbstractContextPathRegisterService
extends AbstractShenyuClientRegisterServiceImpl {
    @Resource
    private RegisterExecutionRepository registerExecutionRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerContextPath(MetaDataRegisterDTO dto) {
        String name = PluginEnum.CONTEXT_PATH.getName();
        String contextPathSelectorId = this.getSelectorService().registerDefault(dto, name, "");
        RegisterExecutionLock lock = this.registerExecutionRepository.getLock(name);
        lock.lock();
        try {
            if (Objects.nonNull(this.getRuleService().findBySelectorIdAndName(contextPathSelectorId, dto.getContextPath()))) {
                return;
            }
            ContextMappingRuleHandle handle = new ContextMappingRuleHandle();
            handle.setContextPath(PathUtils.decoratorContextPath((String)dto.getContextPath()));
            handle.setAddPrefixed(dto.getAddPrefixed());
            this.getRuleService().registerDefault(this.buildContextPathDefaultRuleDTO(contextPathSelectorId, dto, handle.toJson()));
        }
        finally {
            lock.unlock();
        }
    }
}

