/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.utils;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.DiscoveryUpstreamDTO;
import org.apache.shenyu.common.dto.convert.selector.CommonUpstream;
import org.apache.shenyu.common.dto.convert.selector.DivideUpstream;
import org.apache.shenyu.common.dto.convert.selector.DubboUpstream;
import org.apache.shenyu.common.dto.convert.selector.GrpcUpstream;
import org.apache.shenyu.common.dto.convert.selector.TarsUpstream;
import org.apache.shenyu.common.dto.convert.selector.WebSocketUpstream;

public class CommonUpstreamUtils {
    private static final String LOCALHOST = "localhost";
    private static final Integer DEFAULT_WEIGHT = 50;

    public static DivideUpstream buildDefaultDivideUpstream(String host, Integer port) {
        return DivideUpstream.builder().upstreamHost(LOCALHOST).protocol("http://").upstreamUrl(CommonUpstreamUtils.buildUrl(host, port)).weight(50).warmup(600000).timestamp(System.currentTimeMillis()).status(Objects.nonNull(port) && StringUtils.isNotBlank((CharSequence)host)).build();
    }

    public static DiscoveryUpstreamDTO buildDefaultDiscoveryUpstreamDTO(String host, Integer port, String protocol) {
        DiscoveryUpstreamDTO discoveryUpstreamDTO = new DiscoveryUpstreamDTO();
        discoveryUpstreamDTO.setProps("{\"warmupTime\":\"10\"}");
        discoveryUpstreamDTO.setUrl(CommonUpstreamUtils.buildUrl(host, port));
        discoveryUpstreamDTO.setProtocol(protocol);
        discoveryUpstreamDTO.setStatus(0);
        discoveryUpstreamDTO.setWeight(DEFAULT_WEIGHT);
        return discoveryUpstreamDTO;
    }

    public static DivideUpstream buildDefaultAliveDivideUpstream(String upstreamUrl) {
        return DivideUpstream.builder().upstreamHost(LOCALHOST).protocol("http://").upstreamUrl(upstreamUrl).weight(DEFAULT_WEIGHT.intValue()).warmup(600000).timestamp(System.currentTimeMillis()).build();
    }

    public static DivideUpstream buildDivideUpstream(String protocol, String host, Integer port) {
        return DivideUpstream.builder().upstreamHost(LOCALHOST).protocol(protocol).upstreamUrl(CommonUpstreamUtils.buildUrl(host, port)).weight(50).warmup(600000).timestamp(System.currentTimeMillis()).status(Objects.nonNull(port) && StringUtils.isNotBlank((CharSequence)host)).build();
    }

    public static DivideUpstream buildAliveDivideUpstream(String protocol, String upstreamUrl) {
        return DivideUpstream.builder().upstreamHost(LOCALHOST).protocol(protocol).upstreamUrl(upstreamUrl).weight(50).warmup(600000).timestamp(System.currentTimeMillis()).build();
    }

    public static WebSocketUpstream buildWebSocketUpstream(String protocol, String host, Integer port) {
        return WebSocketUpstream.builder().host(LOCALHOST).protocol(protocol).upstreamUrl(CommonUpstreamUtils.buildUrl(host, port)).weight(DEFAULT_WEIGHT.intValue()).warmup(600000).timestamp(System.currentTimeMillis()).status(Objects.nonNull(port) && StringUtils.isNotBlank((CharSequence)host)).build();
    }

    public static DubboUpstream buildDefaultDubboUpstream(String host, Integer port) {
        return DubboUpstream.builder().upstreamHost(LOCALHOST).protocol("dubbo://").upstreamUrl(CommonUpstreamUtils.buildUrl(host, port)).weight(DEFAULT_WEIGHT.intValue()).warmup(600000).timestamp(System.currentTimeMillis()).status(Objects.nonNull(port) && StringUtils.isNotBlank((CharSequence)host)).build();
    }

    public static DubboUpstream buildAliveDubboUpstream(String upstreamUrl) {
        return DubboUpstream.builder().upstreamHost(LOCALHOST).protocol("dubbo://").upstreamUrl(upstreamUrl).weight(DEFAULT_WEIGHT.intValue()).warmup(600000).timestamp(System.currentTimeMillis()).build();
    }

    public static GrpcUpstream buildDefaultGrpcUpstream(String host, Integer port) {
        return GrpcUpstream.builder().upstreamUrl(CommonUpstreamUtils.buildUrl(host, port)).weight(DEFAULT_WEIGHT.intValue()).timestamp(System.currentTimeMillis()).status(Objects.nonNull(port) && StringUtils.isNotBlank((CharSequence)host)).build();
    }

    public static GrpcUpstream buildAliveGrpcUpstream(String upstreamUrl) {
        return GrpcUpstream.builder().upstreamUrl(upstreamUrl).weight(50).timestamp(System.currentTimeMillis()).build();
    }

    public static TarsUpstream buildDefaultTarsUpstream(String host, Integer port) {
        return TarsUpstream.builder().upstreamUrl(CommonUpstreamUtils.buildUrl(host, port)).weight(DEFAULT_WEIGHT.intValue()).warmup(600000).timestamp(System.currentTimeMillis()).status(Objects.nonNull(port) && StringUtils.isNotBlank((CharSequence)host)).build();
    }

    public static TarsUpstream buildAliveTarsUpstream(String upstreamUrl) {
        return TarsUpstream.builder().upstreamUrl(upstreamUrl).weight(DEFAULT_WEIGHT.intValue()).warmup(600000).timestamp(System.currentTimeMillis()).build();
    }

    public static List<CommonUpstream> convertCommonUpstreamList(List<? extends CommonUpstream> upstreamList) {
        return Optional.ofNullable(upstreamList).orElse(Collections.emptyList()).stream().map(upstream -> new CommonUpstream(upstream.getProtocol(), upstream.getUpstreamHost(), upstream.getUpstreamUrl(), upstream.isStatus(), upstream.getTimestamp())).collect(Collectors.toList());
    }

    public static String buildUrl(String host, Integer port) {
        return Optional.of(String.join((CharSequence)":", host, String.valueOf(port))).orElse(null);
    }
}

