/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.core.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.client.apidocs.annotations.ApiDoc;
import org.apache.shenyu.client.apidocs.annotations.ApiModule;
import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.client.core.exception.ShenyuClientIllegalArgumentException;
import org.apache.shenyu.client.core.utils.OpenApiUtils;
import org.apache.shenyu.common.enums.ApiHttpMethodEnum;
import org.apache.shenyu.common.enums.ApiSourceEnum;
import org.apache.shenyu.common.enums.ApiStateEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.IpUtils;
import org.apache.shenyu.common.utils.UriUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.PropertiesConfig;
import org.apache.shenyu.register.common.dto.ApiDocRegisterDTO;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.enums.EventType;
import org.apache.shenyu.register.common.type.DataTypeParent;
import org.javatuples.Sextet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractContextRefreshedEventListener<T, A extends Annotation>
implements ApplicationListener<ContextRefreshedEvent> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractContextRefreshedEventListener.class);
    protected static final String PATH_SEPARATOR = "/";
    private final ShenyuClientRegisterEventPublisher publisher = ShenyuClientRegisterEventPublisher.getInstance();
    private final AtomicBoolean registered = new AtomicBoolean(false);
    private final Map<Method, MetaDataRegisterDTO> metaDataMap = new ConcurrentHashMap<Method, MetaDataRegisterDTO>();
    private final String appName;
    private final String contextPath;
    private final String ipAndPort;
    private final String host;
    private final String port;
    private ApplicationContext context;

    public AbstractContextRefreshedEventListener(PropertiesConfig clientConfig, ShenyuClientRegisterRepository shenyuClientRegisterRepository) {
        Properties props = clientConfig.getProps();
        this.appName = props.getProperty("appName");
        this.contextPath = Optional.ofNullable(props.getProperty("contextPath")).map(UriUtils::repairData).orElse("");
        if (StringUtils.isBlank((CharSequence)this.appName) && StringUtils.isBlank((CharSequence)this.contextPath)) {
            String errorMsg = "client register param must config the appName or contextPath";
            LOG.error(errorMsg);
            throw new ShenyuClientIllegalArgumentException(errorMsg);
        }
        this.ipAndPort = props.getProperty("ipAndPort");
        this.host = props.getProperty("host");
        this.port = props.getProperty("port");
        this.publisher.start(shenyuClientRegisterRepository);
    }

    public void onApplicationEvent(@NonNull ContextRefreshedEvent event) {
        this.context = event.getApplicationContext();
        Map<String, T> beans = this.getBeans(this.context);
        if (MapUtils.isEmpty(beans)) {
            return;
        }
        if (!this.registered.compareAndSet(false, true)) {
            return;
        }
        this.publisher.publishEvent((DataTypeParent)this.buildURIRegisterDTO(this.context, beans));
        beans.forEach(this::handle);
        Map apiModules = this.context.getBeansWithAnnotation(ApiModule.class);
        apiModules.forEach((k, v) -> this.handleApiDoc(v, beans));
    }

    private void handleApiDoc(Object bean, Map<String, T> beans) {
        Class<?> apiModuleClass = AopUtils.isAopProxy((Object)bean) ? AopUtils.getTargetClass((Object)bean) : bean.getClass();
        ApiModule apiModule = apiModuleClass.getDeclaredAnnotation(ApiModule.class);
        if (Objects.nonNull(apiModule) && apiModule.generated()) {
            Method[] methods;
            for (Method method : methods = ReflectionUtils.getUniqueDeclaredMethods(apiModuleClass)) {
                if (!method.isAnnotationPresent(ApiDoc.class)) continue;
                List<ApiDocRegisterDTO> apis = this.buildApiDocDTO(bean, method, beans);
                for (ApiDocRegisterDTO apiDocRegisterDTO : apis) {
                    this.publisher.publishEvent((DataTypeParent)apiDocRegisterDTO);
                }
            }
        }
    }

    private List<ApiDocRegisterDTO> buildApiDocDTO(Object bean, Method method, Map<String, T> beans) {
        Annotation annotation;
        AtomicBoolean generated = new AtomicBoolean(false);
        Pair pairs = Stream.of(method.getDeclaredAnnotations()).filter(ApiDoc.class::isInstance).findAny().map(item -> {
            ApiDoc apiDoc = (ApiDoc)item;
            generated.set(apiDoc.generated());
            String[] tags = apiDoc.tags();
            List<Object> tagsList = new ArrayList();
            if (tags.length > 0 && StringUtils.isNotBlank((CharSequence)tags[0])) {
                tagsList = Arrays.asList(tags);
            }
            return Pair.of((Object)apiDoc.desc(), tagsList);
        }).orElse(Pair.of((Object)"", new ArrayList()));
        if (!generated.get()) {
            return Collections.emptyList();
        }
        Class<?> clazz = AopUtils.isAopProxy((Object)bean) ? AopUtils.getTargetClass((Object)bean) : bean.getClass();
        String superPath = this.buildApiSuperPath(clazz, AnnotatedElementUtils.findMergedAnnotation(clazz, this.getAnnotationType()));
        if (superPath.contains("*")) {
            superPath = superPath.substring(0, superPath.lastIndexOf(PATH_SEPARATOR));
        }
        if (Objects.isNull(annotation = AnnotatedElementUtils.findMergedAnnotation(clazz, this.getAnnotationType()))) {
            return Lists.newArrayList();
        }
        Sextet<String[], String, String, ApiHttpMethodEnum[], RpcTypeEnum, String> sextet = this.buildApiDocSextet(method, annotation, beans);
        if (Objects.isNull(sextet)) {
            return Lists.newArrayList();
        }
        String contextPath = this.getContextPath();
        String[] value0 = (String[])sextet.getValue0();
        ArrayList list = Lists.newArrayList();
        for (String value : value0) {
            ApiHttpMethodEnum[] value3;
            String apiPath = this.pathJoin(contextPath, superPath, value);
            for (ApiHttpMethodEnum apiHttpMethodEnum : value3 = (ApiHttpMethodEnum[])sextet.getValue3()) {
                String documentJson = this.buildDocumentJson((List)pairs.getRight(), apiPath, method);
                String extJson = this.buildExtJson(method);
                ApiDocRegisterDTO build = ApiDocRegisterDTO.builder().consume((String)sextet.getValue1()).produce((String)sextet.getValue2()).httpMethod(apiHttpMethodEnum.getValue()).contextPath(contextPath).ext(extJson).document(documentJson).rpcType(((RpcTypeEnum)sextet.getValue4()).getName()).version((String)sextet.getValue5()).apiDesc((String)pairs.getLeft()).tags((List)pairs.getRight()).apiPath(apiPath).apiSource(ApiSourceEnum.ANNOTATION_GENERATION.getValue()).state(Integer.valueOf(ApiStateEnum.UNPUBLISHED.getState())).apiOwner("admin").eventType(EventType.REGISTER).build();
                list.add(build);
            }
        }
        return list;
    }

    private String buildExtJson(Method method) {
        MetaDataRegisterDTO metaData = this.metaDataMap.get(method);
        if (Objects.isNull(metaData)) {
            return "{}";
        }
        ApiDocRegisterDTO.ApiExt ext = new ApiDocRegisterDTO.ApiExt();
        ext.setHost(this.getHost());
        ext.setPort(Integer.valueOf(this.getPort()));
        ext.setServiceName(metaData.getServiceName());
        ext.setMethodName(metaData.getMethodName());
        ext.setParameterTypes(metaData.getParameterTypes());
        ext.setRpcExt(metaData.getRpcExt());
        ext = this.customApiDocExt(ext);
        return GsonUtils.getInstance().toJson((Object)ext);
    }

    protected ApiDocRegisterDTO.ApiExt customApiDocExt(ApiDocRegisterDTO.ApiExt ext) {
        return ext;
    }

    private String buildDocumentJson(List<String> tags, String path, Method method) {
        ImmutableMap documentMap = ImmutableMap.builder().put((Object)"tags", tags).put((Object)"operationId", (Object)path).put((Object)"parameters", OpenApiUtils.generateDocumentParameters(path, method)).put((Object)"responses", OpenApiUtils.generateDocumentResponse(path)).build();
        return GsonUtils.getInstance().toJson((Object)documentMap);
    }

    protected abstract Sextet<String[], String, String, ApiHttpMethodEnum[], RpcTypeEnum, String> buildApiDocSextet(Method var1, Annotation var2, Map<String, T> var3);

    protected abstract Map<String, T> getBeans(ApplicationContext var1);

    protected abstract URIRegisterDTO buildURIRegisterDTO(ApplicationContext var1, Map<String, T> var2);

    protected void handle(String beanName, T bean) {
        Method[] methods;
        Class<?> clazz = this.getCorrectedClass(bean);
        Annotation beanShenyuClient = AnnotatedElementUtils.findMergedAnnotation(clazz, this.getAnnotationType());
        String superPath = this.buildApiSuperPath(clazz, beanShenyuClient);
        if (Objects.nonNull(beanShenyuClient) && superPath.contains("*")) {
            this.handleClass(clazz, bean, beanShenyuClient, superPath);
            return;
        }
        for (Method method : methods = ReflectionUtils.getUniqueDeclaredMethods(clazz)) {
            this.handleMethod(bean, clazz, beanShenyuClient, method, superPath);
        }
    }

    protected Class<?> getCorrectedClass(T bean) {
        Class clazz = bean.getClass();
        if (AopUtils.isAopProxy(bean)) {
            clazz = AopUtils.getTargetClass(bean);
        }
        return clazz;
    }

    protected abstract String buildApiSuperPath(Class<?> var1, @Nullable A var2);

    protected void handleClass(Class<?> clazz, T bean, @NonNull A beanShenyuClient, String superPath) {
        this.publisher.publishEvent((DataTypeParent)this.buildMetaDataDTO(bean, beanShenyuClient, this.pathJoin(this.contextPath, superPath), clazz, null));
    }

    protected void handleMethod(T bean, Class<?> clazz, @Nullable A beanShenyuClient, Method method, String superPath) {
        Annotation methodShenyuClient = AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, this.getAnnotationType());
        if (Objects.nonNull(methodShenyuClient)) {
            MetaDataRegisterDTO metaData = this.buildMetaDataDTO(bean, methodShenyuClient, this.buildApiPath(method, superPath, methodShenyuClient), clazz, method);
            this.publisher.publishEvent((DataTypeParent)metaData);
            this.metaDataMap.put(method, metaData);
        }
    }

    protected abstract Class<A> getAnnotationType();

    protected abstract String buildApiPath(Method var1, String var2, @NonNull A var3);

    protected String pathJoin(String ... path) {
        StringBuilder result = new StringBuilder(PATH_SEPARATOR);
        for (String p : path) {
            if (!result.toString().endsWith(PATH_SEPARATOR)) {
                result.append(PATH_SEPARATOR);
            }
            result.append(p.startsWith(PATH_SEPARATOR) ? p.replaceFirst(PATH_SEPARATOR, "") : p);
        }
        return result.toString();
    }

    protected abstract MetaDataRegisterDTO buildMetaDataDTO(T var1, @NonNull A var2, String var3, Class<?> var4, Method var5);

    public ShenyuClientRegisterEventPublisher getPublisher() {
        return this.publisher;
    }

    public Map<Method, MetaDataRegisterDTO> getMetaDataMap() {
        return this.metaDataMap;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getIpAndPort() {
        return this.ipAndPort;
    }

    public String getHost() {
        return IpUtils.isCompleteHost((String)this.host) ? this.host : IpUtils.getHost((String)this.host);
    }

    public String getPort() {
        return StringUtils.isBlank((CharSequence)this.port) ? "-1" : this.port;
    }

    public ApplicationContext getContext() {
        return this.context;
    }
}

