/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.core.disruptor.executor;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shenyu.disruptor.consumer.QueueConsumerExecutor;
import org.apache.shenyu.register.common.subsriber.AbstractQueueConsumerFactory;
import org.apache.shenyu.register.common.subsriber.ExecutorTypeSubscriber;
import org.apache.shenyu.register.common.type.DataType;
import org.apache.shenyu.register.common.type.DataTypeParent;

public final class RegisterClientConsumerExecutor<T extends DataTypeParent>
extends QueueConsumerExecutor<T> {
    private final Map<DataType, ExecutorTypeSubscriber<T>> subscribers;

    private RegisterClientConsumerExecutor(Map<DataType, ExecutorTypeSubscriber<T>> executorSubscriberMap) {
        this.subscribers = new EnumMap<DataType, ExecutorTypeSubscriber<T>>(executorSubscriberMap);
    }

    public void run() {
        DataTypeParent data = (DataTypeParent)this.getData();
        this.subscribers.get(data.getType()).executor((Collection)Lists.newArrayList((Object[])new DataTypeParent[]{data}));
    }

    public static class RegisterClientExecutorFactory<T extends DataTypeParent>
    extends AbstractQueueConsumerFactory<T> {
        public RegisterClientConsumerExecutor<T> create() {
            Map<DataType, ExecutorTypeSubscriber> map = this.getSubscribers().stream().map(e -> (ExecutorTypeSubscriber)e).collect(Collectors.toMap(ExecutorTypeSubscriber::getType, e -> e));
            return new RegisterClientConsumerExecutor(map);
        }

        public String fixName() {
            return "shenyu_register_client";
        }
    }
}

