/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.core.disruptor.subcriber;

import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.net.Socket;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.shenyu.client.core.shutdown.ShenyuClientShutdownHook;
import org.apache.shenyu.client.core.shutdown.ShutdownHookManager;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.enums.EventType;
import org.apache.shenyu.register.common.subsriber.ExecutorTypeSubscriber;
import org.apache.shenyu.register.common.type.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class ShenyuClientURIExecutorSubscriber
implements ExecutorTypeSubscriber<URIRegisterDTO> {
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuClientURIExecutorSubscriber.class);
    private final ShenyuClientRegisterRepository shenyuClientRegisterRepository;

    public ShenyuClientURIExecutorSubscriber(ShenyuClientRegisterRepository shenyuClientRegisterRepository) {
        this.shenyuClientRegisterRepository = shenyuClientRegisterRepository;
    }

    public DataType getType() {
        return DataType.URI;
    }

    public void executor(Collection<URIRegisterDTO> dataList) {
        for (URIRegisterDTO uriRegisterDTO : dataList) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            while (true) {
                try {
                    Socket ignored = new Socket(uriRegisterDTO.getHost(), (int)uriRegisterDTO.getPort());
                    Throwable throwable = null;
                    if (ignored == null) break;
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break;
                    }
                    ignored.close();
                }
                catch (IOException e) {
                    long sleepTime = 1000L;
                    if (stopwatch.elapsed(TimeUnit.SECONDS) > 5L) {
                        LOG.error("host:{}, port:{} connection failed, will retry", (Object)uriRegisterDTO.getHost(), (Object)uriRegisterDTO.getPort());
                        if (stopwatch.elapsed(TimeUnit.SECONDS) > 180L) {
                            sleepTime = 10000L;
                        }
                    }
                    try {
                        TimeUnit.MILLISECONDS.sleep(sleepTime);
                    }
                    catch (InterruptedException ex) {
                        LOG.error("interrupted when sleep", (Throwable)ex);
                    }
                    continue;
                }
                break;
            }
            ShenyuClientShutdownHook.delayOtherHooks();
            this.shenyuClientRegisterRepository.persistURI(uriRegisterDTO);
            ShutdownHookManager.get().addShutdownHook(new Thread(() -> {
                URIRegisterDTO offlineDTO = new URIRegisterDTO();
                BeanUtils.copyProperties((Object)uriRegisterDTO, (Object)offlineDTO);
                offlineDTO.setEventType(EventType.OFFLINE);
                this.shenyuClientRegisterRepository.offline(offlineDTO);
            }), 2);
        }
    }
}

