/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.core.register;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.shenyu.client.core.register.ApiBean;
import org.apache.shenyu.client.core.register.extractor.ApiBeansExtractor;
import org.apache.shenyu.client.core.register.registrar.ApiRegistrar;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public final class ClientApiRefreshedEventListener
implements ApplicationListener<ContextRefreshedEvent> {
    private final List<ApiRegistrar> apiRegistrars;
    private final ApiBeansExtractor apiBeanExtractor;

    public ClientApiRefreshedEventListener(List<ApiRegistrar> apiRegistrars, ApiBeansExtractor apiBeanExtractor) {
        this.apiBeanExtractor = apiBeanExtractor;
        this.apiRegistrars = apiRegistrars;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        List<ApiBean> apiBeans = this.apiBeanExtractor.extract(event.getApplicationContext());
        for (ApiRegistrar registrar : this.apiRegistrars) {
            registrar.register(ClientApiRefreshedEventListener.copy(apiBeans));
        }
    }

    @NotNull
    private static List<ApiBean> copy(List<ApiBean> apiBeans) {
        return apiBeans.stream().map(ApiBean::copy).collect(Collectors.toList());
    }
}

