/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.core.register;

import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.client.core.register.ClientRegisterConfig;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.enums.EventType;
import org.apache.shenyu.register.common.type.DataTypeParent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public final class ClientInfoRefreshedEventListener
implements ApplicationListener<ContextRefreshedEvent> {
    private final String contextPath;
    private final String appName;
    private final RpcTypeEnum rpcTypeEnum;
    private final String host;
    private final Integer port;
    private final ShenyuClientRegisterEventPublisher publisher;

    public ClientInfoRefreshedEventListener(ClientRegisterConfig clientRegisterConfig, ShenyuClientRegisterEventPublisher publisher) {
        this.contextPath = clientRegisterConfig.getContextPath();
        this.appName = clientRegisterConfig.getAppName();
        this.rpcTypeEnum = clientRegisterConfig.getRpcTypeEnum();
        this.host = clientRegisterConfig.getHost();
        this.port = clientRegisterConfig.getPort();
        this.publisher = publisher;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        URIRegisterDTO uriRegisterDTO = URIRegisterDTO.builder().contextPath(this.contextPath).appName(this.appName).rpcType(this.rpcTypeEnum.getName()).host(this.host).port(this.port).eventType(EventType.REGISTER).build();
        this.publisher.publishEvent((DataTypeParent)uriRegisterDTO);
    }
}

