/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.core.register.registrar;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.client.apidocs.annotations.ApiDoc;
import org.apache.shenyu.client.apidocs.annotations.ApiModule;
import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.client.core.register.ApiBean;
import org.apache.shenyu.client.core.register.ClientRegisterConfig;
import org.apache.shenyu.client.core.register.matcher.AnnotatedApiBeanMatcher;
import org.apache.shenyu.client.core.register.matcher.AnnotatedApiDefinitionMatcher;
import org.apache.shenyu.client.core.register.matcher.Matcher;
import org.apache.shenyu.client.core.register.registrar.AbstractApiRegistrar;
import org.apache.shenyu.client.core.utils.OpenApiUtils;
import org.apache.shenyu.common.enums.ApiHttpMethodEnum;
import org.apache.shenyu.common.enums.ApiSourceEnum;
import org.apache.shenyu.common.enums.ApiStateEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.PathUtils;
import org.apache.shenyu.register.common.dto.ApiDocRegisterDTO;
import org.apache.shenyu.register.common.enums.EventType;

public abstract class AbstractApiDocRegistrar
extends AbstractApiRegistrar<ApiDocRegisterDTO> {
    private static final String API_DOC_VERSION = "v0.01";
    private final RpcTypeEnum rpcTypeEnum;
    private final String host;
    private final Integer port;
    private final Boolean addPrefixed;
    private final ClientRegisterConfig clientRegisterConfig;
    private final Matcher<ApiBean> apiBeanMatcher = new AnnotatedApiBeanMatcher(ApiModule.class);
    private final Matcher<ApiBean.ApiDefinition> apiDefinitionMatcher = new AnnotatedApiDefinitionMatcher(ApiDoc.class);

    protected AbstractApiDocRegistrar(ShenyuClientRegisterEventPublisher publisher, ClientRegisterConfig clientRegisterConfig) {
        super(publisher);
        this.rpcTypeEnum = clientRegisterConfig.getRpcTypeEnum();
        this.host = clientRegisterConfig.getHost();
        this.port = clientRegisterConfig.getPort();
        this.addPrefixed = clientRegisterConfig.getAddPrefixed();
        this.clientRegisterConfig = clientRegisterConfig;
    }

    @Override
    protected Boolean match(ApiBean apiBean) {
        return this.apiBeanMatcher.match(apiBean);
    }

    @Override
    protected Boolean match(ApiBean.ApiDefinition apiDefinition) {
        return this.apiDefinitionMatcher.match(apiDefinition);
    }

    @Override
    protected List<ApiDocRegisterDTO> parse(ApiBean.ApiDefinition apiDefinition) {
        ApiDoc apiDoc = apiDefinition.getAnnotation(ApiDoc.class);
        ArrayList tags = apiDoc.tags().length == 1 && StringUtils.isBlank((CharSequence)apiDoc.tags()[0]) ? Lists.newArrayList() : Arrays.asList(apiDoc.tags());
        String desc = apiDoc.desc();
        String apiPath = PathUtils.pathJoin((String[])new String[]{this.clientRegisterConfig.getContextPath(), apiDefinition.getApiBean().getBeanPath(), apiDefinition.getMethodPath()});
        HttpApiSpecificInfo httpApiSpecificInfo = this.doParse(apiDefinition);
        ArrayList<ApiDocRegisterDTO> apiDocRegisters = new ArrayList<ApiDocRegisterDTO>();
        String documentJson = this.buildDocumentJson(tags, apiPath, apiDefinition.getApiMethod());
        String extJson = this.buildExtJson(apiDefinition);
        for (ApiHttpMethodEnum apiHttpMethodEnum : httpApiSpecificInfo.apiHttpMethodEnums) {
            ApiDocRegisterDTO build = ApiDocRegisterDTO.builder().consume(httpApiSpecificInfo.consume).produce(httpApiSpecificInfo.produce).httpMethod(apiHttpMethodEnum.getValue()).contextPath(this.clientRegisterConfig.getContextPath()).ext(extJson).document(documentJson).rpcType(this.rpcTypeEnum.getName()).version(API_DOC_VERSION).apiDesc(desc).tags((List)tags).apiPath(apiPath).apiSource(ApiSourceEnum.ANNOTATION_GENERATION.getValue()).state(Integer.valueOf(ApiStateEnum.PUBLISHED.getState())).apiOwner("admin").eventType(EventType.REGISTER).build();
            apiDocRegisters.add(build);
        }
        return apiDocRegisters;
    }

    private String buildDocumentJson(List<String> tags, String path, Method method) {
        ImmutableMap documentMap = ImmutableMap.builder().put((Object)"tags", tags).put((Object)"operationId", (Object)path).put((Object)"parameters", OpenApiUtils.generateDocumentParameters(path, method)).put((Object)"responses", OpenApiUtils.generateDocumentResponse(path)).build();
        return GsonUtils.getInstance().toJson((Object)documentMap);
    }

    private String buildExtJson(ApiBean.ApiDefinition apiDefinition) {
        ApiDocRegisterDTO.ApiExt ext = new ApiDocRegisterDTO.ApiExt();
        ext.setHost(this.host);
        ext.setPort(this.port);
        ext.setServiceName(apiDefinition.getApiBean().getBeanClass().getName());
        ext.setMethodName(apiDefinition.getApiMethodName());
        ext.setParameterTypes(apiDefinition.getParameterTypes());
        ext.setRpcExt(apiDefinition.getPropertiesValue("RpcExt"));
        ext.setAddPrefixed(this.addPrefixed.booleanValue());
        if (this.rpcTypeEnum == RpcTypeEnum.HTTP) {
            ext.setProtocol("http://");
        }
        if (this.rpcTypeEnum == RpcTypeEnum.WEB_SOCKET) {
            ext.setProtocol("ws://");
        }
        return GsonUtils.getInstance().toJson((Object)ext);
    }

    protected abstract HttpApiSpecificInfo doParse(ApiBean.ApiDefinition var1);

    public static class HttpApiSpecificInfo {
        private final String produce;
        private final String consume;
        private final List<ApiHttpMethodEnum> apiHttpMethodEnums;

        public HttpApiSpecificInfo(String produce, String consume, List<ApiHttpMethodEnum> apiHttpMethodEnums) {
            this.produce = produce;
            this.consume = consume;
            this.apiHttpMethodEnums = apiHttpMethodEnums;
        }

        public String getProduce() {
            return this.produce;
        }

        public String getConsume() {
            return this.consume;
        }

        public List<ApiHttpMethodEnum> getApiHttpMethodEnums() {
            return this.apiHttpMethodEnums;
        }
    }
}

