/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.core.register.registrar;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.shenyu.client.core.register.ApiBean;
import org.apache.shenyu.client.core.register.matcher.ApiRegisterProcessor;
import org.apache.shenyu.client.core.register.registrar.ApiRegistrar;
import org.springframework.beans.factory.InitializingBean;

public abstract class BaseApiRegistrarImpl
implements ApiRegistrar,
InitializingBean {
    private final List<ApiRegisterProcessor> processors = new ArrayList<ApiRegisterProcessor>();

    public void afterPropertiesSet() {
        this.processors.sort(Comparator.comparingInt(ApiRegisterProcessor::order));
    }

    public void addApiProcessor(ApiRegisterProcessor processor) {
        if (this.supportedType(processor)) {
            this.processors.add(processor);
            this.processors.sort(Comparator.comparingInt(ApiRegisterProcessor::order));
        }
    }

    @Override
    public void register(ApiBean apiBean) {
        for (ApiRegisterProcessor processor : this.processors) {
            processor.process(apiBean);
        }
        if (ApiBean.Status.INIT.equals((Object)apiBean.getStatus())) {
            apiBean.setStatus(ApiBean.Status.REGISTRABLE_API);
            for (ApiBean.ApiDefinition definition : apiBean.getApiDefinitions()) {
                if (!ApiBean.Status.INIT.equals((Object)definition.getStatus())) continue;
                definition.setStatus(ApiBean.Status.REGISTRABLE);
            }
        }
        this.doRegister(apiBean);
    }

    protected void doRegister(ApiBean apiBean) {
        if (ApiBean.Status.REGISTRABLE_BEAN.equals((Object)apiBean.getStatus())) {
            this.doRegisterBean(apiBean);
        }
        if (ApiBean.Status.REGISTRABLE_API.equals((Object)apiBean.getStatus())) {
            this.doRegisterApi(apiBean);
        }
        if (ApiBean.Status.REGISTRABLE.equals((Object)apiBean.getStatus())) {
            this.doRegisterBean(apiBean);
            this.doRegisterApi(apiBean);
        }
    }

    private boolean supportedType(ApiRegisterProcessor processor) {
        for (Class<?> type : processor.supportedRegisterDataType()) {
            if (!type.isAssignableFrom(this.registerDataType())) continue;
            return true;
        }
        return false;
    }

    private void doRegisterApi(ApiBean apiBean) {
        for (ApiBean.ApiDefinition api : apiBean.getApiDefinitions()) {
            if (!ApiBean.Status.REGISTRABLE.equals((Object)api.getStatus())) continue;
            this.doRegisterApi(api);
        }
    }

    protected abstract void doRegisterApi(ApiBean.ApiDefinition var1);

    protected abstract void doRegisterBean(ApiBean var1);
}

