/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.core.shutdown;

import java.lang.reflect.Field;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.shenyu.client.core.shutdown.ShutdownHookManager;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShenyuClientShutdownHook {
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuClientShutdownHook.class);
    private static final AtomicBoolean DELAY = new AtomicBoolean(false);
    private static String hookNamePrefix = "ShenyuClientShutdownHook";
    private static AtomicInteger hookId = new AtomicInteger(0);
    private static Properties props;
    private static IdentityHashMap<Thread, Thread> delayHooks;
    private static IdentityHashMap<Thread, Thread> delayedHooks;

    public ShenyuClientShutdownHook() {
    }

    public ShenyuClientShutdownHook(ShenyuClientRegisterRepository repository, ShenyuRegisterCenterConfig config) {
        String name = String.join((CharSequence)"-", hookNamePrefix, String.valueOf(hookId.incrementAndGet()));
        ShutdownHookManager.get().addShutdownHook(new Thread(() -> ((ShenyuClientRegisterRepository)repository).closeRepository(), name), 1);
        LOG.info("Add hook {}", (Object)name);
        props = config.getProps();
    }

    public static void set(ShenyuClientRegisterRepository repository, Properties props) {
        String name = String.join((CharSequence)"-", hookNamePrefix, String.valueOf(hookId.incrementAndGet()));
        ShutdownHookManager.get().addShutdownHook(new Thread(() -> ((ShenyuClientRegisterRepository)repository).closeRepository(), name), 1);
        LOG.info("Add hook {}", (Object)name);
        ShenyuClientShutdownHook.props = props;
    }

    public static void delayOtherHooks() {
        if (!DELAY.compareAndSet(false, true)) {
            return;
        }
        TakeoverOtherHooksThread thread = new TakeoverOtherHooksThread();
        thread.start();
    }

    static {
        delayHooks = new IdentityHashMap();
        delayedHooks = new IdentityHashMap();
    }

    private static class TakeoverOtherHooksThread
    extends Thread {
        private TakeoverOtherHooksThread() {
        }

        @Override
        public void run() {
            int shutdownWaitTime = Integer.parseInt(props.getProperty("shutdownWaitTime", "3000"));
            int delayOtherHooksExecTime = Integer.parseInt(props.getProperty("delayOtherHooksExecTime", "2000"));
            IdentityHashMap hooks = null;
            try {
                Class<?> clazz = Class.forName(props.getProperty("applicationShutdownHooksClassName", "java.lang.ApplicationShutdownHooks"));
                Field field = clazz.getDeclaredField(props.getProperty("applicationShutdownHooksFieldName", "hooks"));
                field.setAccessible(true);
                hooks = (IdentityHashMap)field.get(clazz);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
            long s = System.currentTimeMillis();
            while (System.currentTimeMillis() - s < (long)delayOtherHooksExecTime) {
                Iterator iterator = ((IdentityHashMap)Objects.requireNonNull(hooks)).keySet().iterator();
                while (iterator.hasNext()) {
                    Thread hook = (Thread)iterator.next();
                    if (hook.getName().startsWith(hookNamePrefix) || delayHooks.containsKey(hook) || delayedHooks.containsKey(hook)) continue;
                    Thread delayHook = new Thread(() -> {
                        LOG.info("sleep {}ms", (Object)shutdownWaitTime);
                        try {
                            TimeUnit.MILLISECONDS.sleep(shutdownWaitTime);
                        }
                        catch (InterruptedException ex) {
                            LOG.error(ex.getMessage(), (Throwable)ex);
                        }
                        hook.run();
                    }, hook.getName());
                    delayHooks.put(delayHook, delayHook);
                    iterator.remove();
                }
                iterator = delayHooks.keySet().iterator();
                while (iterator.hasNext()) {
                    Thread delayHook = (Thread)iterator.next();
                    Runtime.getRuntime().addShutdownHook(delayHook);
                    delayedHooks.put(delayHook, delayHook);
                    iterator.remove();
                    LOG.info("hook {} will sleep {}ms when it start", (Object)delayHook.getName(), (Object)shutdownWaitTime);
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(100L);
                }
                catch (InterruptedException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                }
            }
            hookNamePrefix = null;
            hookId = new AtomicInteger(0);
            props = null;
            delayHooks = null;
            delayedHooks = null;
        }
    }
}

