/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.core.shutdown;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShutdownHookManager {
    private static final ShutdownHookManager MGR = new ShutdownHookManager();
    private static final Logger LOG = LoggerFactory.getLogger(ShutdownHookManager.class);
    private final Set<HookEntry> hooks = Collections.synchronizedSet(new HashSet());
    private final AtomicBoolean shutdownInProgress = new AtomicBoolean(false);

    private ShutdownHookManager() {
    }

    public static ShutdownHookManager get() {
        return MGR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Runnable> getShutdownHooksInOrder() {
        ArrayList<HookEntry> list;
        Set<HookEntry> set = ShutdownHookManager.MGR.hooks;
        synchronized (set) {
            list = new ArrayList<HookEntry>(ShutdownHookManager.MGR.hooks);
        }
        Collections.sort(list, (o1, o2) -> ((HookEntry)o2).priority - ((HookEntry)o1).priority);
        ArrayList<Runnable> ordered = new ArrayList<Runnable>();
        for (HookEntry entry : list) {
            ordered.add(entry.hook);
        }
        return ordered;
    }

    public void addShutdownHook(Runnable shutdownHook) {
        if (shutdownHook == null) {
            throw new IllegalArgumentException("shutdownHook cannot be NULL");
        }
        if (this.shutdownInProgress.get()) {
            throw new IllegalStateException("Shutdown in progress, cannot add a shutdownHook");
        }
        this.hooks.add(new HookEntry(shutdownHook, 0));
    }

    public void addShutdownHook(Runnable shutdownHook, int priority) {
        if (shutdownHook == null) {
            throw new IllegalArgumentException("shutdownHook cannot be NULL");
        }
        if (this.shutdownInProgress.get()) {
            throw new IllegalStateException("Shutdown in progress, cannot add a shutdownHook");
        }
        this.hooks.add(new HookEntry(shutdownHook, priority));
    }

    public boolean removeShutdownHook(Runnable shutdownHook) {
        if (this.shutdownInProgress.get()) {
            throw new IllegalStateException("Shutdown in progress, cannot remove a shutdownHook");
        }
        return this.hooks.remove(new HookEntry(shutdownHook, 0));
    }

    public boolean hasShutdownHook(Runnable shutdownHook) {
        return this.hooks.contains(new HookEntry(shutdownHook, 0));
    }

    public boolean isShutdownInProgress() {
        return this.shutdownInProgress.get();
    }

    public void clearShutdownHooks() {
        this.hooks.clear();
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            ShutdownHookManager.MGR.shutdownInProgress.set(true);
            for (Runnable hook : MGR.getShutdownHooksInOrder()) {
                try {
                    hook.run();
                }
                catch (Throwable ex) {
                    LOG.error(ex.getMessage(), ex);
                }
            }
        }));
    }

    private static class HookEntry {
        private final Runnable hook;
        private final int priority;

        HookEntry(Runnable hook, int priority) {
            this.hook = hook;
            this.priority = priority;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HookEntry hookEntry = (HookEntry)o;
            return this.priority == hookEntry.priority && Objects.equals(this.hook, hookEntry.hook);
        }

        public int hashCode() {
            return Objects.hash(this.hook, this.priority);
        }
    }
}

