/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.core.utils;

import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.client.core.utils.UrlPathUtils;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;

public class OpenApiUtils {
    private static final String EVERY_PATH = "**";
    private static final String LEFT_ANGLE_BRACKETS = "{";
    private static final String RIGHT_ANGLE_BRACKETS = "}";
    private static final String[] QUERY_CLASSES = new String[]{"org.springframework.web.bind.annotation.RequestParam", "org.springframework.web.bind.annotation.RequestPart"};

    public static List<Parameter> generateDocumentParameters(String path, Method method) {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        Pair<Boolean, Annotation[][]> query = OpenApiUtils.isQuery(method);
        if (((Boolean)query.getLeft()).booleanValue()) {
            for (Annotation[] annotations : (Annotation[][])query.getRight()) {
                if (annotations.length <= 0 || !OpenApiUtils.isQueryName(annotations[0].annotationType().getName(), QUERY_CLASSES)) continue;
                for (Annotation annotation : annotations) {
                    String name = "";
                    boolean required = false;
                    if (StringUtils.equals((CharSequence)QUERY_CLASSES[0], (CharSequence)annotation.annotationType().getName())) {
                        RequestParam requestParam = (RequestParam)annotation;
                        name = requestParam.value();
                        required = requestParam.required();
                    }
                    if (StringUtils.equals((CharSequence)QUERY_CLASSES[1], (CharSequence)annotation.annotationType().getName())) {
                        RequestPart requestPart = (RequestPart)annotation;
                        name = requestPart.value();
                        required = requestPart.required();
                    }
                    Parameter parameter = new Parameter();
                    parameter.setIn("query");
                    parameter.setRequired(required);
                    parameter.setName(name);
                    parameter.setSchema(new Schema("string", null));
                    list.add(parameter);
                }
            }
        } else {
            List<String> segments = UrlPathUtils.getSegments(path);
            for (String segment : segments) {
                if (EVERY_PATH.equals(segment)) {
                    Parameter parameter = new Parameter();
                    parameter.setIn("path");
                    parameter.setName(segment);
                    parameter.setRequired(true);
                    parameter.setSchema(new Schema("string", null));
                    list.add(parameter);
                }
                if (!segment.startsWith(LEFT_ANGLE_BRACKETS) || !segment.endsWith(RIGHT_ANGLE_BRACKETS)) continue;
                String name = segment.substring(1, segment.length() - 1);
                Parameter parameter = new Parameter();
                parameter.setIn("path");
                parameter.setName(name);
                parameter.setRequired(true);
                parameter.setSchema(new Schema("string", null));
                list.add(parameter);
            }
        }
        return list;
    }

    private static Pair<Boolean, Annotation[][]> isQuery(Method method) {
        int n = 0;
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Annotation[][] annotationArray = parameterAnnotations;
        int n2 = annotationArray.length;
        if (n < n2) {
            Annotation[] parameterAnnotation = annotationArray[n];
            if (parameterAnnotation.length > 0 && OpenApiUtils.isQueryName(parameterAnnotation[0].annotationType().getName(), QUERY_CLASSES)) {
                return Pair.of((Object)true, (Object)parameterAnnotations);
            }
            return Pair.of((Object)false, null);
        }
        return Pair.of((Object)false, null);
    }

    private static boolean isQueryName(String name, String[] names) {
        for (String s : names) {
            if (!StringUtils.equals((CharSequence)name, (CharSequence)s)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Object> generateDocumentResponse(String path) {
        ImmutableMap contentMap = ImmutableMap.builder().put((Object)"*/*", (Object)ImmutableMap.of((Object)"schema", (Object)ImmutableMap.of((Object)"type", (Object)"string"))).build();
        ImmutableMap successMap = ImmutableMap.builder().put((Object)"description", (Object)path).put((Object)"content", (Object)contentMap).build();
        ImmutableMap notFoundMap = ImmutableMap.builder().put((Object)"description", (Object)StringUtils.join((Object[])new String[]{"the path [", path, "] not found"})).put((Object)"content", (Object)contentMap).build();
        ImmutableMap conflictMap = ImmutableMap.builder().put((Object)"description", (Object)"conflict").put((Object)"content", (Object)contentMap).build();
        return ImmutableMap.builder().put((Object)"200", (Object)successMap).put((Object)"404", (Object)notFoundMap).put((Object)"409", (Object)conflictMap).build();
    }

    public static class Schema {
        private String type;
        private String format;

        public Schema(String type, String format) {
            this.type = type;
            this.format = format;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }
    }

    public static class Parameter {
        private String name;
        private String in;
        private String description;
        private boolean required;
        private Schema schema;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getIn() {
            return this.in;
        }

        public void setIn(String in) {
            this.in = in;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public void setSchema(Schema schema) {
            this.schema = schema;
        }
    }
}

