/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.springmvc.proceeor.register;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.client.core.register.ApiBean;
import org.apache.shenyu.client.core.register.matcher.BaseAnnotationApiProcessor;
import org.apache.shenyu.client.springmvc.annotation.ShenyuSpringMvcClient;

public class ShenyuSpringMvcClientProcessorImpl
extends BaseAnnotationApiProcessor<ShenyuSpringMvcClient> {
    public void process(ApiBean apiBean, ShenyuSpringMvcClient annotation) {
        apiBean.setBeanPath(annotation.path());
        apiBean.addProperties("desc", annotation.desc());
        if (StringUtils.isNotBlank((CharSequence)apiBean.getPropertiesValue("rule"))) {
            apiBean.addProperties("rule", annotation.ruleName());
        }
        apiBean.addProperties("value", annotation.value());
        apiBean.addProperties("enabled", Objects.toString(annotation.enabled()));
        apiBean.addProperties("registerMetaData", Objects.toString(annotation.registerMetaData()));
        if (!annotation.registerMetaData()) {
            apiBean.setStatus(ApiBean.Status.CAN_NO_BE_REGISTERED);
        } else {
            apiBean.setStatus(ApiBean.Status.REGISTRABLE_API);
        }
        for (ApiBean.ApiDefinition definition : apiBean.getApiDefinitions()) {
            definition.setStatus(apiBean.getStatus());
        }
    }

    public void process(ApiBean.ApiDefinition definition, ShenyuSpringMvcClient annotation) {
        definition.setMethodPath(annotation.path());
        definition.addProperties("desc", annotation.desc());
        definition.addProperties("rule", annotation.ruleName());
        definition.addProperties("value", annotation.value());
        definition.addProperties("enabled", Objects.toString(annotation.enabled()));
        definition.addProperties("registerMetaData", Objects.toString(annotation.registerMetaData()));
        if (!annotation.registerMetaData()) {
            definition.setStatus(ApiBean.Status.CAN_NO_BE_REGISTERED);
        } else {
            definition.setStatus(ApiBean.Status.REGISTRABLE);
        }
    }

    public Class<ShenyuSpringMvcClient> matchAnnotation() {
        return ShenyuSpringMvcClient.class;
    }
}

