/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.dto.convert.rule;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shenyu.common.dto.convert.rule.RuleHandle;
import org.apache.shenyu.common.dto.convert.rule.impl.ContextMappingHandle;
import org.apache.shenyu.common.dto.convert.rule.impl.DivideRuleHandle;
import org.apache.shenyu.common.dto.convert.rule.impl.DubboRuleHandle;
import org.apache.shenyu.common.dto.convert.rule.impl.SofaRuleHandle;
import org.apache.shenyu.common.dto.convert.rule.impl.SpringCloudRuleHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.exception.ShenyuException;

public final class RuleHandleFactory {
    private static final Map<String, Class<? extends RuleHandle>> RPC_TYPE_TO_RULE_HANDLE_CLASS = new ConcurrentHashMap<String, Class<? extends RuleHandle>>();
    private static final Class<? extends RuleHandle> DEFAULT_RULE_HANDLE = SpringCloudRuleHandle.class;

    public static RuleHandle ruleHandle(String name, String path) {
        Class<? extends RuleHandle> clazz = RPC_TYPE_TO_RULE_HANDLE_CLASS.getOrDefault(name, DEFAULT_RULE_HANDLE);
        try {
            return clazz.newInstance().createDefault(path);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ShenyuException(String.format("Init RuleHandle failed with plugin name: %s, rule class: %s, exception: %s", name, clazz.getSimpleName(), e.getMessage()));
        }
    }

    static {
        RPC_TYPE_TO_RULE_HANDLE_CLASS.put(PluginEnum.DIVIDE.getName(), DivideRuleHandle.class);
        RPC_TYPE_TO_RULE_HANDLE_CLASS.put(PluginEnum.DUBBO.getName(), DubboRuleHandle.class);
        RPC_TYPE_TO_RULE_HANDLE_CLASS.put(PluginEnum.SOFA.getName(), SofaRuleHandle.class);
        RPC_TYPE_TO_RULE_HANDLE_CLASS.put(PluginEnum.SPRING_CLOUD.getName(), SpringCloudRuleHandle.class);
        RPC_TYPE_TO_RULE_HANDLE_CLASS.put(PluginEnum.CONTEXT_PATH.getName(), ContextMappingHandle.class);
    }
}

